#include <windows.h>
#include <commdlg.h>
#include <assert.h>
#include <setjmp.h>
#include <io.h>
#include "resource.h"
#define APPNAME            "Mpeg2Encode" /* The name of this application */
#define BASEWINDOWTITLE    "MPEG2 Software Simulation" /* The title bar text */
#define MAXFILENAME        256           /* maximum length of file pathname      */
#define MAXCUSTFILTER      40            /* maximum size of custom filter buffer */

// MS Windows related variables
LRESULT CALLBACK WndProc(HWND   hWnd,       // window handle
                         UINT   message,    // type of message
                         WPARAM uParam,     // additional information
                         LPARAM lParam);    // additional information
static HINSTANCE   hInst;          // current instance
static HWND        ghWnd   =NULL;  // handle to main window
static char        szFileName[MAXFILENAME]="";
static unsigned short gusState;
static jmp_buf     env;
extern int         __argc;
extern char      **__argv;
#define argc       __argc
#define argv       __argv

#define   START     0
#define		READY	    1
#define   PLAYING   2
#define   PAUSED    3
#define   FINISH    4
#define		STOP	    5

#include <stdio.h>
#include <stdlib.h>

#define GLOBAL /* used by global.h */
#include "config.h"
#include "global.h"

/* private prototypes */
static void init _ANSI_ARGS_((void));
static void readparmfile _ANSI_ARGS_((char *fname));
static void readquantmat _ANSI_ARGS_((void));


// MS Windows related functions
/////////////////////////////////////////////////////////////////////////////
//
// yield function to simulate multitasking on MS Windows
//
void myYield(void)
{
    MSG		msg;

  if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
  {
    TranslateMessage(&msg);// Translates virtual key codes
    DispatchMessage(&msg); // Dispatches message to window
	}
  if (gusState==PAUSED)
     longjmp(env,error);
}

//
// initializations
//
static BOOL InitApplication(HINSTANCE hInstance)
{
   WNDCLASS  wc;

   // Fill in window class structure with parameters that describe the
   // main window.

   wc.style         = CS_OWNDC | CS_HREDRAW | CS_VREDRAW;// Class style(s).
   wc.lpfnWndProc   = (WNDPROC)WndProc;           // Window Procedure
   wc.cbClsExtra    = 0;                          // No per-class extra data.
   wc.cbWndExtra    = 0;                          // No per-window extra data.
   wc.hInstance     = hInstance;                  // Owner of this class
   wc.hIcon         = LoadIcon (hInstance, APPNAME); // Icon name from .RC
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);// Cursor
   wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);   // Default color
   wc.lpszMenuName  = APPNAME;                    // Menu name from .RC
   wc.lpszClassName = APPNAME;                    // Name to register as

   // Register the window class and return success/failure code.
   return (RegisterClass(&wc));
}

static BOOL InitInstance(HINSTANCE hInstance,int       nCmdShow)
{

    // Save the instance handle in static variable, which will be used in
    // many subsequence calls from this application to Windows.

    hInst = hInstance; // Store instance handle in our global variable

    // Create a main window for this application instance.

    ghWnd = CreateWindow(APPNAME,            // See RegisterClass() call.
                         BASEWINDOWTITLE,    // Text for window title bar.
                         WS_OVERLAPPEDWINDOW &
                         ~WS_THICKFRAME &
                         ~WS_MAXIMIZEBOX,    // Window style.
                         CW_USEDEFAULT,
                         0,
                         CW_USEDEFAULT,
                         0,                  // Use default positioning
                         NULL,               // Overlapped windows have no parent.
                         NULL,               // Use the window class menu.
                         hInstance,          // This instance owns this window.
                         NULL                // We don't use any data in our WM_CREATE
        );

    // If window could not be created, return "failure"
    if (!ghWnd)
       return (FALSE);

    // Make the window visible; update its client area; and return "success"
    ShowWindow(ghWnd, nCmdShow); // Show the window
    UpdateWindow(ghWnd);         // Sends WM_PAINT message

    return (TRUE);              // We succeeded...

}

//
// prompts the user for the efile name
//
static BOOL AskUserFileName(char szFileName[],char szFileTitle[], char szFilterSpec[], BOOL bSave)
{
   /* new variables for common dialogs */
   static char         szInitialDirectory[MAXFILENAME]="";
          OPENFILENAME ofn;

   memset(&ofn,0,sizeof(ofn));

   /* fill in non-variant fields of OPENFILENAME struct. */
   ofn.lStructSize       = sizeof(OPENFILENAME);
   ofn.hwndOwner         = ghWnd;
   ofn.lpstrFilter       = szFilterSpec;
   ofn.lpstrCustomFilter = NULL;
   ofn.nMaxCustFilter    = 0;
   ofn.nFilterIndex      = 0;
   ofn.lpstrFile         = szFileName;
   ofn.nMaxFile          = MAXFILENAME;
   if (!szInitialDirectory[0])
      GetModuleFileName(hInst, szInitialDirectory, MAXFILENAME);

   // strip the file name
   *(LPSTR)strrchr(szInitialDirectory,'\\')=0;

   ofn.lpstrInitialDir     = szInitialDirectory;
   ofn.lpstrFileTitle      = szFileTitle;
   ofn.nMaxFileTitle       = MAXFILENAME;
   ofn.lpstrTitle          = NULL;
   ofn.lpstrDefExt         = "MPG";
   ofn.Flags               = 0;

   if (bSave)
   {
      if (!GetSaveFileName ((LPOPENFILENAME)&ofn))
         return FALSE;
   }
   else if (!GetOpenFileName ((LPOPENFILENAME)&ofn))
      return FALSE;

   // save the current directory
   lstrcpy(szInitialDirectory,szFileName);
   return TRUE;
}


/*********************************************************************************
 *
 * About box
 *
*********************************************************************************
*/

BOOL CALLBACK About(HWND   hDlg,         // window handle of the dialog box
                    UINT   message,      // type of message
                    WPARAM uParam,       // message-specific information
                    LPARAM lParam)
{
   switch (message)
   {
      case WM_COMMAND:                     // message: received a command
         if (LOWORD(uParam) == IDOK || LOWORD(uParam) == IDCANCEL)
         {
            EndDialog(hDlg, TRUE);        // Exit the dialog
            return (TRUE);
         }
         break;
   }
   return (FALSE); // Didn't process the message

   lParam; // This will prevent 'unused formal parameter' warnings
}

//
// Main window procedure
//
LRESULT CALLBACK WndProc(HWND   hWnd,       // window handle
                         UINT   message,    // type of message
                         WPARAM uParam,     // additional information
                         LPARAM lParam)     // additional information
{
   switch (message)
   {
     case WM_CLOSE:
      if (gusState==PLAYING)
         gusState = PAUSED;
	    myYield();
      return (DefWindowProc(hWnd, message, uParam, lParam));
	    break;


     case WM_DESTROY:  // message: window being destroyed
      if (gusState==PLAYING)
         gusState = PAUSED;
	    myYield();
      PostQuitMessage(0);
      break;

     case WM_COMMAND:  // message: command from application menu
      {
        int wmId, wmEvent;

        wmId    = LOWORD(uParam);
        wmEvent = HIWORD(uParam);

        switch (wmId)
        {
           case IDM_FILE_OPEN_PARAMS:
           {
              static char szFilterSpec[]="Encoder Parameter File\0*.PAR\0\All Files\0\*.*\0\0";
              char szWindowTitle[80];
              char szFileTitle[MAXFILENAME];

              szFileName[0]=0;
              if (!AskUserFileName (szFileName,szFileTitle,szFilterSpec,0))
                 return FALSE;

              lstrcpy(szWindowTitle, BASEWINDOWTITLE);
              lstrcat(szWindowTitle, " - ");
              lstrcat(szWindowTitle, szFileTitle);
              SetWindowText(hWnd, szFileTitle);

              // enable play menu
              EnableMenuItem(GetMenu(hWnd), IDM_RUN, MF_ENABLED);

              gusState = READY;
              break;
           }

           case IDM_RUN:
           {
              static char szFilterSpec[]="MPEG2 Video Files\0*.M2V\0MPEG1 Video Files\0*.M1V\0MPEG Files\0*.MPG\0All Files (*.*)\0*.*\0";
              char  szWindowTitle[256];
              char  szOldWindowTitle[256];
              char  szTargetName[MAXFILENAME];
              char  szFileTitle [MAXFILENAME];
              char *argv[]={NULL,szFileName,szTargetName};
              int e;

              szTargetName[0]=0;
              if (!AskUserFileName (szTargetName,szFileTitle,szFilterSpec,1))
                 return FALSE;

              GetWindowText(hWnd, szOldWindowTitle, 256);
              lstrcpy(szWindowTitle, szOldWindowTitle);
              lstrcat(szWindowTitle, " - ");
              lstrcat(szWindowTitle, szTargetName);
              SetWindowText(hWnd, szWindowTitle);

              // disable play menu while playing
              EnableMenuItem(GetMenu(hWnd), IDM_STOP, MF_ENABLED);
              EnableMenuItem(GetMenu(hWnd), IDM_RUN, MF_GRAYED | MF_DISABLED);
              EnableMenuItem(GetMenu(hWnd), IDM_FILE_OPEN_PARAMS, MF_GRAYED | MF_DISABLED);

              // play the movie. It returns after the playing ended
              gusState = PLAYING;
              e=setjmp(env);
              if (!e)
                 main(3,argv);
              gusState = STOP;

              // disable stop menu
              EnableMenuItem(GetMenu(hWnd), IDM_STOP, MF_GRAYED | MF_DISABLED);
              EnableMenuItem(GetMenu(hWnd), IDM_RUN, MF_ENABLED);
              EnableMenuItem(GetMenu(hWnd), IDM_FILE_OPEN_PARAMS, MF_ENABLED);
              SetWindowText(hWnd, szOldWindowTitle);
              break;
           }
           case IDM_STOP:
              if (gusState==PLAYING)
                 gusState=PAUSED;
              // force a task switch to allow the decoder to see the stop command
              myYield();
              break;

           case IDM_EXIT:
              if (gusState==PLAYING)
                 gusState=PAUSED;
              // force a task switch to allow the decoder to see the stop command
              myYield();
              SendMessage(hWnd, WM_CLOSE, 0, 0l);
              break;

           case IDM_ABOUT:
           {
              FARPROC lpProcAbout;  // pointer to the "About" function

              lpProcAbout = MakeProcInstance((FARPROC)About, hInst);
              DialogBox(hInst,                 // current instance
                        "AboutBox",            // dlg resource to use
                        hWnd,                  // parent handle
                        (DLGPROC)lpProcAbout); // About() instance address

              FreeProcInstance(lpProcAbout);
              break;
           }

        }
        break;
      }

     default:          // Passes it on if unproccessed
        return (DefWindowProc(hWnd, message, uParam, lParam));
   }
   return (0);
}

//
// program entry point
//
int APIENTRY WinMain(HINSTANCE   hInstance,
                     HINSTANCE   hPrevInstance,
                     LPSTR       lpCmdLine,
                     int         nCmdShow)
{
    MSG msg;

    if (!hPrevInstance)
       // Other instances of app running?
        if (!InitApplication(hInstance))
           // Initialize shared things
           return (FALSE);     // Exits if unable to initialize

    /* Perform initializations that apply to a specific instance */
    if (!InitInstance(hInstance, nCmdShow))
       return (FALSE);

    gusState = STOP;

    /* Acquire and dispatch messages until a WM_QUIT message is received. */
    while (GetMessage(&msg, // message structure
                      NULL,   // handle of window receiving the message
                      0,      // lowest message to examine
                      0))     // highest message to examine
    {
        TranslateMessage(&msg);// Translates virtual key codes
        DispatchMessage(&msg); // Dispatches message to window
    }

    return (msg.wParam); // Returns the value from PostQuitMessage

    lpCmdLine; // This will prevent 'unused formal parameter' warnings
}

void Output(char *pFormatInfo, ...)
{
    va_list	marker;
    char	szPrintBuffer[512];

    va_start(marker, pFormatInfo);

    wvsprintf(szPrintBuffer, pFormatInfo, marker);

    OutputDebugString(szPrintBuffer);
    myYield();
}

void message(char *pFormatInfo, ...)
{
    va_list	marker;
    char	szPrintBuffer[512];

    va_start(marker, pFormatInfo);

    wvsprintf(szPrintBuffer, pFormatInfo, marker);

    {
       HDC  hDC;

       hDC=GetDC(ghWnd);
       TextOut(hDC,10,10,szPrintBuffer,strlen(szPrintBuffer));
       ReleaseDC(ghWnd,hDC);
    }
    myYield();
}

int main(argc,argv)
int argc;
char *argv[];
{
  if (argc!=3)
  {
    printf("\n%s, %s\n",version,author);
    printf("Usage: mpeg2encode in.par out.m2v\n");
    exit(0);
  }

  /* read parameter file */
  readparmfile(argv[1]);

  /* read quantization matrices */
  readquantmat();

  /* open output file */
  if (!(outfile=fopen(argv[2],"wb")))
  {
    sprintf(errortext,"Couldn't create output file %s",argv[1]);
    error(errortext);
  }

  init();
  putseq();

  fclose(outfile);
  fclose(statfile);

  return 0;
}

static void init()
{
  int i, size;
  static int block_count_tab[3] = {6,8,12};

  initbits();
  init_fdct();
  init_idct();

  /* Non-linear qscale not yet implemented */
  q_scale_type=0;

  /* round picture dimensions to nearest multiple of 16 or 32 */
  mb_width = (horizontal_size+15)/16;
  mb_height = prog_seq ? (vertical_size+15)/16 : 2*((vertical_size+31)/32);
  mb_height2 = fieldpic ? mb_height>>1 : mb_height; /* for field pictures */
  width = 16*mb_width;
  height = 16*mb_height;

  chrom_width = (chroma_format==CHROMA444) ? width : width>>1;
  chrom_height = (chroma_format!=CHROMA420) ? height : height>>1;

  height2 = fieldpic ? height>>1 : height;
  width2 = fieldpic ? width<<1 : width;
  chrom_width2 = fieldpic ? chrom_width<<1 : chrom_width;

  block_count = block_count_tab[chroma_format-1];

  /* clip table */
  if (!(clp = (unsigned char *)malloc(1024)))
    error("malloc failed\n");
  clp+= 384;
  for (i=-384; i<640; i++)
    clp[i] = (i<0) ? 0 : ((i>255) ? 255 : i);

  for (i=0; i<3; i++)
  {
    size = (i==0) ? width*height : chrom_width*chrom_height;

    if (!(newrefframe[i] = (unsigned char *)malloc(size)))
      error("malloc failed\n");
    if (!(oldrefframe[i] = (unsigned char *)malloc(size)))
      error("malloc failed\n");
    if (!(auxframe[i] = (unsigned char *)malloc(size)))
      error("malloc failed\n");
    if (!(neworgframe[i] = (unsigned char *)malloc(size)))
      error("malloc failed\n");
    if (!(oldorgframe[i] = (unsigned char *)malloc(size)))
      error("malloc failed\n");
    if (!(auxorgframe[i] = (unsigned char *)malloc(size)))
      error("malloc failed\n");
    if (!(predframe[i] = (unsigned char *)malloc(size)))
      error("malloc failed\n");
  }

  mbinfo = (struct mbinfo *)malloc(mb_width*mb_height2*sizeof(struct mbinfo));

  if (!mbinfo)
    error("malloc failed\n");

  blocks =
    (short (*)[64])malloc(mb_width*mb_height2*block_count*sizeof(short [64]));

  if (!blocks)
    error("malloc failed\n");

  /* open statistics output file */
  if (statname[0]=='-')
    statfile = stdout;
  else if (!(statfile = fopen(statname,"w")))
  {
    sprintf(errortext,"Couldn't create statistics output file %s",statname);
    error(errortext);
  }
}

void error(text)
char *text;
{
  fprintf(stderr,text);
  putc('\n',stderr);
  exit(1);
}

static void readparmfile(fname)
char *fname;
{
  int i;
  int h,m,s,f;
  FILE *fd;
  char line[256];
  static double ratetab[8]=
    {24000.0/1001.0,24.0,25.0,30000.0/1001.0,30.0,50.0,60000.0/1001.0,60.0};
  extern int r,Xi,Xb,Xp,d0i,d0p,d0b; /* rate control */
  extern double avg_act; /* rate control */

  if (!(fd = fopen(fname,"r")))
  {
    sprintf(errortext,"Couldn't open parameter file %s",fname);
    error(errortext);
  }

  fgets(id_string,254,fd);
  fgets(line,254,fd); sscanf(line,"%s",tplorg);
  fgets(line,254,fd); sscanf(line,"%s",tplref);
  fgets(line,254,fd); sscanf(line,"%s",iqname);
  fgets(line,254,fd); sscanf(line,"%s",niqname);
  fgets(line,254,fd); sscanf(line,"%s",statname);
  fgets(line,254,fd); sscanf(line,"%d",&inputtype);
  fgets(line,254,fd); sscanf(line,"%d",&nframes);
  fgets(line,254,fd); sscanf(line,"%d",&frame0);
  fgets(line,254,fd); sscanf(line,"%d:%d:%d:%d",&h,&m,&s,&f);
  fgets(line,254,fd); sscanf(line,"%d",&N);
  fgets(line,254,fd); sscanf(line,"%d",&M);
  fgets(line,254,fd); sscanf(line,"%d",&mpeg1);
  fgets(line,254,fd); sscanf(line,"%d",&fieldpic);
  fgets(line,254,fd); sscanf(line,"%d",&horizontal_size);
  fgets(line,254,fd); sscanf(line,"%d",&vertical_size);
  fgets(line,254,fd); sscanf(line,"%d",&aspectratio);
  fgets(line,254,fd); sscanf(line,"%d",&frame_rate_code);
  fgets(line,254,fd); sscanf(line,"%lf",&bit_rate);
  fgets(line,254,fd); sscanf(line,"%d",&vbv_buffer_size);
  fgets(line,254,fd); sscanf(line,"%d",&low_delay);
  fgets(line,254,fd); sscanf(line,"%d",&constrparms);
  fgets(line,254,fd); sscanf(line,"%d",&profile);
  fgets(line,254,fd); sscanf(line,"%d",&level);
  fgets(line,254,fd); sscanf(line,"%d",&prog_seq);
  fgets(line,254,fd); sscanf(line,"%d",&chroma_format);
  fgets(line,254,fd); sscanf(line,"%d",&video_format);
  fgets(line,254,fd); sscanf(line,"%d",&color_primaries);
  fgets(line,254,fd); sscanf(line,"%d",&transfer_characteristics);
  fgets(line,254,fd); sscanf(line,"%d",&matrix_coefficients);
  fgets(line,254,fd); sscanf(line,"%d",&display_horizontal_size);
  fgets(line,254,fd); sscanf(line,"%d",&display_vertical_size);
  fgets(line,254,fd); sscanf(line,"%d",&dc_prec);
  fgets(line,254,fd); sscanf(line,"%d",&topfirst);
  fgets(line,254,fd); sscanf(line,"%d %d %d",
    frame_pred_dct_tab,frame_pred_dct_tab+1,frame_pred_dct_tab+2);

  fgets(line,254,fd); sscanf(line,"%d %d %d",
    conceal_tab,conceal_tab+1,conceal_tab+2);

  fgets(line,254,fd); sscanf(line,"%d %d %d",
    qscale_tab,qscale_tab+1,qscale_tab+2);

  fgets(line,254,fd); sscanf(line,"%d %d %d",
    intravlc_tab,intravlc_tab+1,intravlc_tab+2);
  fgets(line,254,fd); sscanf(line,"%d %d %d",
    altscan_tab,altscan_tab+1,altscan_tab+2);
  fgets(line,254,fd); sscanf(line,"%d",&repeatfirst);
  fgets(line,254,fd); sscanf(line,"%d",&prog_frame);
/* intra slice interval refresh period */
  fgets(line,254,fd); sscanf(line,"%d",&P);
  fgets(line,254,fd); sscanf(line,"%d",&r);
  fgets(line,254,fd); sscanf(line,"%lf",&avg_act);
  fgets(line,254,fd); sscanf(line,"%d",&Xi);
  fgets(line,254,fd); sscanf(line,"%d",&Xp);
  fgets(line,254,fd); sscanf(line,"%d",&Xb);
  fgets(line,254,fd); sscanf(line,"%d",&d0i);
  fgets(line,254,fd); sscanf(line,"%d",&d0p);
  fgets(line,254,fd); sscanf(line,"%d",&d0b);

  if (N<1)
    error("N must be positive");
  if (M<1)
    error("M must be positive");
  if (N%M != 0)
    error("N must be an integer multiple of M");

  motion_data = (struct motion_data *)malloc(M*sizeof(struct motion_data));
  if (!motion_data)
    error("Couldn't allocate motion_data\n");

  for (i=0; i<M; i++)
  {
    fgets(line,254,fd);
    sscanf(line,"%d %d %d %d",
      &motion_data[i].forw_hor_f_code, &motion_data[i].forw_vert_f_code,
      &motion_data[i].sxf, &motion_data[i].syf);

    if (i!=0)
    {
      fgets(line,254,fd);
      sscanf(line,"%d %d %d %d",
        &motion_data[i].back_hor_f_code, &motion_data[i].back_vert_f_code,
        &motion_data[i].sxb, &motion_data[i].syb);
    }
  }

  fclose(fd);

  /* make flags boolean (x!=0 -> x=1) */
  mpeg1 = !!mpeg1;
  fieldpic = !!fieldpic;
  low_delay = !!low_delay;
  constrparms = !!constrparms;
  prog_seq = !!prog_seq;
  topfirst = !!topfirst;

  for (i=0; i<3; i++)
  {
    frame_pred_dct_tab[i] = !!frame_pred_dct_tab[i];
    conceal_tab[i] = !!conceal_tab[i];
    qscale_tab[i] = !!qscale_tab[i];
    intravlc_tab[i] = !!intravlc_tab[i];
    altscan_tab[i] = !!altscan_tab[i];
  }
  repeatfirst = !!repeatfirst;
  prog_frame = !!prog_frame;

  /* make sure MPEG specific parameters are valid */
  range_checks();

  frame_rate = ratetab[frame_rate_code-1];

  /* timecode -> frame number */
  tc0 = h;
  tc0 = 60*tc0 + m;
  tc0 = 60*tc0 + s;
  tc0 = (int)(frame_rate+0.5)*tc0 + f;

  if (!mpeg1)
  {
    profile_and_level_checks();
  }
  else
  {
    /* MPEG-1 */
    if (constrparms)
    {
      if (horizontal_size>768
          || vertical_size>576
          || ((horizontal_size+15)/16)*((vertical_size+15)/16)>396
          || ((horizontal_size+15)/16)*((vertical_size+15)/16)*frame_rate>396*25.0
          || frame_rate>30.0)
      {
        if (!quiet)
          fprintf(stderr,"Warning: setting constrained_parameters_flag = 0\n");
        constrparms = 0;
      }
    }

    if (constrparms)
    {
      for (i=0; i<M; i++)
      {
        if (motion_data[i].forw_hor_f_code>4)
        {
          if (!quiet)
            fprintf(stderr,"Warning: setting constrained_parameters_flag = 0\n");
          constrparms = 0;
          break;
        }

        if (motion_data[i].forw_vert_f_code>4)
        {
          if (!quiet)
            fprintf(stderr,"Warning: setting constrained_parameters_flag = 0\n");
          constrparms = 0;
          break;
        }

        if (i!=0)
        {
          if (motion_data[i].back_hor_f_code>4)
          {
            if (!quiet)
              fprintf(stderr,"Warning: setting constrained_parameters_flag = 0\n");
            constrparms = 0;
            break;
          }

          if (motion_data[i].back_vert_f_code>4)
          {
            if (!quiet)
              fprintf(stderr,"Warning: setting constrained_parameters_flag = 0\n");
            constrparms = 0;
            break;
          }
        }
      }
    }
  }

  /* relational checks */

  if (mpeg1)
  {
    if (!prog_seq)
    {
      if (!quiet)
        fprintf(stderr,"Warning: setting progressive_sequence = 1\n");
      prog_seq = 1;
    }

    if (chroma_format!=CHROMA420)
    {
      if (!quiet)
        fprintf(stderr,"Warning: setting chroma_format = 1 (4:2:0)\n");
      chroma_format = CHROMA420;
    }

    if (dc_prec!=0)
    {
      if (!quiet)
        fprintf(stderr,"Warning: setting intra_dc_precision = 0\n");
      dc_prec = 0;
    }

    for (i=0; i<3; i++)
      if (intravlc_tab[i])
      {
        if (!quiet)
          fprintf(stderr,"Warning: setting intravlc_tab[%d] = 0\n",i);
        intravlc_tab[i] = 0;
      }
    for (i=0; i<3; i++)
      if (altscan_tab[i])
      {
        if (!quiet)
          fprintf(stderr,"Warning: setting altscan_tab[%d] = 0\n",i);
        altscan_tab[i] = 0;
      }
  }

  if (!mpeg1 && constrparms)
  {
    if (!quiet)
      fprintf(stderr,"Warning: setting constrained_parameters_flag = 0\n");
    constrparms = 0;
  }

  if (prog_seq && !prog_frame)
  {
    if (!quiet)
      fprintf(stderr,"Warning: setting progressive_frame = 1\n");
    prog_frame = 1;
  }

  if (prog_frame && fieldpic)
  {
    if (!quiet)
      fprintf(stderr,"Warning: setting field_pictures = 0\n");
    fieldpic = 0;
  }

  if (!prog_frame && repeatfirst)
  {
    if (!quiet)
      fprintf(stderr,"Warning: setting repeat_first_field = 0\n");
    repeatfirst = 0;
  }

  if (prog_frame)
  {
    for (i=0; i<3; i++)
      if (!frame_pred_dct_tab[i])
      {
        if (!quiet)
          fprintf(stderr,"Warning: setting frame_pred_frame_dct[%d] = 1\n",i);
        frame_pred_dct_tab[i] = 1;
      }
  }

  if (prog_seq && !repeatfirst && topfirst)
  {
    if (!quiet)
      fprintf(stderr,"Warning: setting top_field_first = 0\n");
    topfirst = 0;
  }

  /* search windows */
  for (i=0; i<M; i++)
  {
    if (motion_data[i].sxf > (4<<motion_data[i].forw_hor_f_code)-1)
    {
      if (!quiet)
        fprintf(stderr,
          "Warning: reducing forward horizontal search width to %d\n",
          (4<<motion_data[i].forw_hor_f_code)-1);
      motion_data[i].sxf = (4<<motion_data[i].forw_hor_f_code)-1;
    }

    if (motion_data[i].syf > (4<<motion_data[i].forw_vert_f_code)-1)
    {
      if (!quiet)
        fprintf(stderr,
          "Warning: reducing forward vertical search width to %d\n",
          (4<<motion_data[i].forw_vert_f_code)-1);
      motion_data[i].syf = (4<<motion_data[i].forw_vert_f_code)-1;
    }

    if (i!=0)
    {
      if (motion_data[i].sxb > (4<<motion_data[i].back_hor_f_code)-1)
      {
        if (!quiet)
          fprintf(stderr,
            "Warning: reducing backward horizontal search width to %d\n",
            (4<<motion_data[i].back_hor_f_code)-1);
        motion_data[i].sxb = (4<<motion_data[i].back_hor_f_code)-1;
      }

      if (motion_data[i].syb > (4<<motion_data[i].back_vert_f_code)-1)
      {
        if (!quiet)
          fprintf(stderr,
            "Warning: reducing backward vertical search width to %d\n",
            (4<<motion_data[i].back_vert_f_code)-1);
        motion_data[i].syb = (4<<motion_data[i].back_vert_f_code)-1;
      }
    }
  }

}

static void readquantmat()
{
  int i,v;
  FILE *fd;

  if (iqname[0]=='-')
  {
    /* use default intra matrix */
    load_iquant = 0;
    for (i=0; i<64; i++)
      intra_q[i] = default_intra_quantizer_matrix[i];
  }
  else
  {
    /* read customized intra matrix */
    load_iquant = 1;
    if (!(fd = fopen(iqname,"r")))
    {
      sprintf(errortext,"Couldn't open quant matrix file %s",iqname);
      error(errortext);
    }

    for (i=0; i<64; i++)
    {
      fscanf(fd,"%d",&v);
      if (v<1 || v>255)
        error("invalid value in quant matrix");
      intra_q[i] = v;
    }

    fclose(fd);
  }

  if (niqname[0]=='-')
  {
    /* use default non-intra matrix */
    load_niquant = 0;
    for (i=0; i<64; i++)
      inter_q[i] = 16;
  }
  else
  {
    /* read customized non-intra matrix */
    load_niquant = 1;
    if (!(fd = fopen(niqname,"r")))
    {
      sprintf(errortext,"Couldn't open quant matrix file %s",niqname);
      error(errortext);
    }

    for (i=0; i<64; i++)
    {
      fscanf(fd,"%d",&v);
      if (v<1 || v>255)
        error("invalid value in quant matrix");
      inter_q[i] = v;
    }

    fclose(fd);
  }
}
