{*********************************************************}
{                                                         }
{    Calmira System Library 3.1                           }
{    by Li-Hsin Huang & Erwin Dokter                      }
{    released into the public domain january 2001         }
{                                                         }
{*********************************************************}

unit StylSped;

{ TStyleSpeed is the descendant which overrides Paint to draw a new
  border style over TSpeedButton's border.  There doesn't seem to
  be any noticeable impact on performance.  TStyleSpeed provides
  a new Style property to change between the old TSpeedButton, a
  TBitBtn look and a Windows 95-like button.  (Win95 uses a shade
  of grey which is not in the Windows 3.1 system palette). }

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons;

type
  TSpeedStyle = (sbSpeed, sbBitBtn, sbWin95, sbFlat);

  TStyleSpeed = class(TSpeedButton)
  private
    { Private declarations }
    FStyle: TSpeedStyle;
    FMouseOver: Boolean;
    procedure SetStyle(Value: TSpeedStyle);
  protected
    { Protected declarations }
    procedure Paint; override;
    procedure WMMouseMove(var Message: TWMMouseMove); message WM_MouseMove;
  published
    { Published declarations }
    property Style: TSpeedStyle read FStyle write SetStyle default sbSpeed;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
  end;

procedure Register;

implementation

procedure TStyleSpeed.SetStyle(Value : TSpeedStyle);
begin
  if Value <> FStyle then
  begin
    FStyle := Value;
    Invalidate;
  end;
end;

procedure TStyleSpeed.Paint;
begin
  inherited Paint;
  case Style of
    sbBitBtn:
      with Canvas do
      begin
        Pen.Color := clBtnShadow;
        MoveTo(0, Height - 2);
        LineTo(0, 0);
        LineTo(Width - 1, 0);
        if FState in [bsDown, bsExclusive] then
        begin
          MoveTo(Width - 2, 0);
          LineTo(Width - 2, Height-2);
          LineTo(0, Height - 2);
          Pen.Color := clWindowFrame;
          MoveTo(1, Height - 3);
          LineTo(1, 1);
          LineTo(Width - 2, 1);
          Pen.Color := clBtnHighlight;
          MoveTo(Width - 1, 0);
          LineTo(Width - 1, Height - 1);
          LineTo(-1, Height - 1);
        end;
      end;
    sbWin95:
      with Canvas do
      if FState in [bsDown, bsExclusive] then begin
        Pen.Color := clBtnHighlight;
        MoveTo(Width - 1, 0);
        LineTo(Width - 1, Height - 1);
        LineTo(-1, Height - 1);
      end
      else
      begin
        Pen.Color := clBtnHighlight;
        MoveTo(0, Height - 1);
        LineTo(0, 0);
        LineTo(Width - 1, 0);
        Pen.Color := clBtnFace;
        MoveTo(1, Height - 2);
        LineTo(1, 1);
        LineTo(Width - 2, 1);
        Pixels[0, Height - 1] := clWindowFrame;
        Pixels[1, Height - 2] := clBtnShadow;
      end;
    sbFlat:
      with Canvas do
      begin
        Pen.Color := clBtnFace;
        MoveTo(0, Height - 1);
        LineTo(0, 0);
        LineTo(Width - 1, 0);
        LineTo(Width - 1, Height - 1);
        LineTo(0, Height - 1);
        if not FMouseOver then
        begin
          MoveTo(1, Height - 1);
          LineTo(1, 1);
          LineTo(Width - 2, 1);
          LineTo(Width - 2, height - 2);
          LineTo(1, Height - 2);
        end;
        if FState in [bsDown, bsExclusive] then
        begin
          Pen.Color := clBtnShadow;
          MoveTo(1, Height - 2);
          LineTo(1, 1);
          LineTo(Width - 2, 1);
          Pen.Color := clBtnHighlight;
          LineTo(Width - 2, height - 2);
          LineTo(1, Height - 2);
        end;
      end;
    end;
end;

procedure TStyleSpeed.WMMouseMove(var Message: TWMMouseMove);
begin
  inherited;
  if Style = sbFlat then
  begin
    if not MouseCapture then
    { The Mouse has entered the button}
    begin
      SetCaptureControl(Self);
      if Enabled and Visible Then
      begin
        FMouseOver := True;
        Invalidate;
      end;
    end;
    if MouseCapture and FMouseOver and ((message.XPos < 0) or (Message.YPos < 0)
      or (message.Xpos > Width) or (message.YPos > Height)) then
    { The Mouse has left the button}
    begin
      FMouseOver := False;
      Invalidate;
      SetCaptureControl(Nil);
    end;
  end;
end;

procedure Register;
begin
  RegisterComponents('Calmira', [TStyleSpeed]);
end;

end.
