/*	GEMCTRL.C	5/14/84 - 07/11/85	Lee Jay Lorenzen	*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <struct88.h>
#include <baspag88.h>
#include <obdefs.h>
#include <taddr.h>
#include <gemlib.h>

#define THEDESK 3

#define MBDOWN 0x0001
#define BELL 0x07				/* bell			*/

						/* in PD88.C		*/
EXTERN PD	*getpd();

EXTERN PD	*pstart();
						/* in INPUT88.C		*/
EXTERN WORD	os_mchg();
EXTERN WORD	set_ctrl();
						/* in EVLIB.C		*/
EXTERN WORD	ev_mesag();
EXTERN WORD	ev_multi();
						/* in WMLIB.C		*/
EXTERN WORD	w_getsize();
EXTERN WORD	w_bldactive();
EXTERN WORD	w_setactive();
EXTERN VOID	w_union();
EXTERN VOID	w_clipdraw();
						/* in 			*/
EXTERN WORD	dsptch();

EXTERN LONG	gl_mntree;
EXTERN LONG	menu_tree[];
EXTERN PD	*gl_mnppd;
EXTERN WORD	gl_dacnt;
EXTERN WORD	gl_dabox;
EXTERN PD	*desk_ppd[];

EXTERN OBJECT	W_TREE[];

EXTERN LONG	gl_wtree;
EXTERN LONG	gl_awind;
EXTERN LONG	gl_newdesk;

EXTERN WORD	gl_wtop;
EXTERN WORD	gl_wchar;
EXTERN WORD	gl_hchar;
EXTERN WORD	gl_wbox;
EXTERN WORD	gl_hbox;
EXTERN WORD	gl_width;
EXTERN WORD	gl_height;
EXTERN GRECT	gl_rfull;
EXTERN GRECT	gl_rmenu;

EXTERN WORD	button, xrat, yrat;
EXTERN PD	*gl_mowner, *gl_cowner;

EXTERN LONG	ad_armice, ad_mouse;
EXTERN WORD	gl_moff;

EXTERN THEGLO	D;


GLOBAL MOBLK	gl_ctwait;
GLOBAL WORD	gl_ctmown;

GLOBAL WORD	appl_msg[8];
						/* used to convert from	*/
						/*   window object # to	*/
						/*   window message code*/
GLOBAL WORD	gl_wa[] =
{
	WA_UPLINE,
	WA_DNLINE,
	WA_UPPAGE,
	WA_DNPAGE,
	0x0,
	WA_LFLINE,
	WA_RTLINE,
	WA_LFPAGE,
	WA_RTPAGE
};


MLOCAL WORD		gl_tmpmoff;


/*
*	Send message and wait for the mouse button to come up
*/
	VOID
ct_msgup(message, owner, wh, m1, m2, m3, m4)
	WORD		message, owner, wh;
	WORD		m1, m2, m3, m4;
{
	if (message)
	  ap_sendmsg(appl_msg, message, owner, wh, m1, m2, m3, m4);
						/* wait for button to	*/
						/*   come up if not an	*/
						/*   an arrowed message	*/
	if ( message != WM_ARROWED )
	{
	  while( (button & 0x0001) != 0x0 )
	    dsptch();
	}
}


	VOID
hctl_window(w_handle, mx, my)
	REG WORD	w_handle;
	WORD		mx, my;
{
	GRECT		t, f;
	WORD		x, y, w, h;
	REG WORD	wm, hm;
	WORD		ret;
	WORD		xelev, yelev;
	REG WORD	cpt, message;
	LONG		tree;

	message = 0;
	if ( w_handle == gl_wtop )
	{
						/* went down on active	*/
						/*   window so handle	*/
						/*   control points	*/
	  w_bldactive(w_handle);
	  tree = gl_awind;
	  cpt = ob_find(gl_awind, 0, 10, mx, my);
	  w_getsize(WS_CURR, w_handle, &t);
	  r_get(&t, &x, &y, &w, &h);
	  switch(cpt)
	  {
	    case W_CLOSER:
	    case W_FULLER:
		if ( gr_watchbox(gl_awind, cpt, SELECTED, NORMAL) )
		{
		  message = (cpt == W_CLOSER) ? WM_CLOSED : WM_FULLED;
		  ob_change(gl_awind, cpt, NORMAL, TRUE);
		}
		break;
	    case W_NAME:
	        if ( D.w_win[w_handle].w_kind & MOVER )
		{
		  r_set(&f, 0, gl_hbox, 10000, 10000);
		  gr_dragbox(w, h, x, y, &f, &x, &y);
		  message = WM_MOVED;
		}
		break;
	    case W_SIZER:
		w_getsize(WS_WORK, w_handle, &t);
		t.g_x -= x;
		t.g_y -= y;
		t.g_w -= w;
		t.g_h -= h;
		wm = gl_wchar;
		hm = gl_hchar;
	        if ( D.w_win[w_handle].w_kind & (LFARROW | RTARROW | HSLIDE) )
		  wm = 7 * gl_wbox;
	        if ( D.w_win[w_handle].w_kind & (UPARROW | DNARROW | VSLIDE) )
		  hm = 7 * gl_hbox;
		gr_rubwind(x, y, wm, hm, &t, &w, &h);
		message = WM_SIZED;
		break;
	    case W_HSLIDE:
	    case W_VSLIDE:
		ob_offset(gl_awind, cpt + 1, &xelev, &yelev);
		if ( cpt == W_HSLIDE )
		{
						/* fix up for index	*/
						/*   into gl_wa		*/
		  if ( !(mx < xelev) )
		    cpt += 1;
		}
		else
		{
		  if ( !(my < yelev) )
		    cpt += 1;
		}
						/* fall thru		*/
	    case W_UPARROW:
	    case W_DNARROW:
	    case W_LFARROW:
	    case W_RTARROW:
		message = WM_ARROWED;
		break;
	    case W_HELEV:
	    case W_VELEV:
		message = (cpt == W_HELEV) ? WM_HSLID : WM_VSLID;
					/* slide is 1 less than elev	*/
		x = gr_slidebox(gl_awind, cpt - 1, cpt, (cpt == W_VELEV));
		break;
	  }
	  if (message == WM_ARROWED)
	    x = gl_wa[cpt - W_UPARROW];
	}
	else
	{
						/* went down on inactive*/
						/*   window so tell ap.	*/
						/*   to bring it to top	*/
	  message = WM_TOPPED;
	}
	ct_msgup(message, D.w_win[w_handle].w_owner, w_handle, 
			x, y, w, h);
}

	WORD
hctl_button(mx, my)
	REG WORD	mx, my;
{
	REG WORD	wh;
						/* find out which wind.	*/
						/*   the mouse clicked  */
						/*   over and handle it	*/
	wh = wm_find(mx, my);
	if (wh > 0)
	  hctl_window( wh, mx, my);
}


	WORD
hctl_rect()
{
	WORD		title, item, pid;
	REG WORD	mesag;
	REG PD		*owner;

	if ( gl_mntree != 0x0L )
	{
	  mesag = 0;
	  if ( mn_do(&title, &item) )
	  {
	    owner = gl_mnppd;
	    mesag = MN_SELECTED;
						/* check system menu:	*/
	    if ( title == THEDESK )
	    {
	      if (item > 2)
	      {
		item -= 3;
		mesag = 0x0;
	        owner = desk_ppd[item];
	        do_chg(gl_mntree, title, SELECTED, FALSE, TRUE, TRUE);
		w_nxttop(owner);
		pid = owner->p_pid;
		if (gl_mntree != menu_tree[pid])
		  mn_bar(menu_tree[pid], TRUE, pid);
	      }
	      else
		item += gl_dabox;
	    }
	  }
						/* application menu	*/
						/*   item has been 	*/
						/*   selected so send it*/
	  ct_msgup(mesag, owner, title, item, 0, 0, 0);
	}
}


/*
*	Control change of ownership to this rectangle and this process.
*	Doing the control rectangle first is important.
*/
	VOID
ct_chgown(ppd, pr)
	PD		*ppd;
	GRECT		*pr;
{
	set_ctrl(pr);
	if (!gl_ctmown)
	  set_mown(ppd); 
}


ct_mouse(grabit)
	WORD		grabit;
{

	if (grabit)
	{
	  wm_update(TRUE);
	  gl_ctmown = TRUE;
	  gl_mowner = rlr;
	  gsx_mfset(ad_armice);
	  gl_tmpmoff = gl_moff; 
	  if (gl_tmpmoff)
	    ratinit();
	}
	else
	{
	  if (gl_tmpmoff)
	    gsx_moff();
	  gl_moff = gl_tmpmoff;
	  gsx_mfset(ad_mouse);
	  gl_ctmown = FALSE;
	  wm_update(FALSE);
	}
}


/*
*	Internal process context used to control the screen for use by
*	the menu manager, and the window manager.
*	This process never terminates and forms an integral part of
*	the system.
*/

	WORD
ctlmgr()
{
	REG WORD	ev_which;
	WORD		rets[6];
	WORD		i;
						/* set defaults for 	*/
						/*  multi wait		*/
	gl_ctwait.m_out = FALSE;
	rc_copy(&gl_rmenu, &gl_ctwait.m_x);
	while(TRUE)
	{
						/* fix up ctrl rect	*/
	  w_setactive();
						/* wait for something to*/
						/*   happen, keys need	*/
						/*   to be eaten inc.	*/
						/*   fake key sent by	*/
						/*   or if button already*/
						/*   down, then let other*/
						/*   guys run then do it*/
	  if (button)
	  {
	    for (i=0; i<(NUM_PDS*2); i++)
	      dsptch();
	    ev_which = MU_BUTTON;
	    rets[0] = xrat;
	    rets[1] = yrat;
	  }
	  else
	    ev_which = ev_multi(MU_KEYBD | MU_BUTTON | MU_M1, 
			&gl_ctwait, &gl_ctwait, 
			0x0L, 0x0001ff01L, 0x0L, &rets[0]);
						/* grab screen sink	*/
	  ct_mouse(TRUE);
						/* button down over area*/
						/*   ctrl mgr owns	*/
	  if (ev_which & MU_BUTTON)
	    hctl_button(rets[0], rets[1]);
						/* mouse over menu bar	*/
	  if (ev_which & MU_M1)
	    hctl_rect();
						/* give up screen sink	*/
	  ct_mouse(FALSE);
	}
}


