*	rwa.s
*
*	GEMDOS assembler interface
*
* Originally written by JSL.
*
* MODIFICATION HISTORY
*
*	11 Mar 85	SCC	Added xgetsup() functionality as a hack in _entry().
*				Removed get sup functionality from exit().
*	11 Mar 85	JSL	Changed timer vector number.
*	12 Mar 85	SCC	Modified xgetsup() functionality in _entry().
*	13 Mar 85	SCC	Changed 'xgetsup()' type functionality to
*				'toggle/inquire processor/stack state' type
*				functionality.
*	25 Mar 85	SCC	Modified 'tikhnd:'.  It didn't need to save the
*				registers it was saving.
*	 1 Apr 85	SCC	Modified 'tikhnd:'.  It needed to get the number of
*				milliseconds since last tick into the right place for
*				the stack frame for call to tikfrk().
*	10 Apr 85	SCC	Modified longjmp() to use long return value on stack.
*	12 Apr 85	SCC	Modified exit() to check for function -1 (return
*				address of screen driver.
*	14 Apr 85	SCC	Modified osinit() to disable interrupts while
*				initializing the tick vector.
*	19 Apr 85	SCC	Modified osinit() to preserve the previous state of
*				the SR.
*	22 Apr 85	SCC	Modified the saving of SR to store it temporarily in
*				a static.
*
* NAMES
*
*	JSL	Jason S. Loveman
*	SCC	Steven C. Cavender


	.text
	.globl	_s68
	.globl	_s68l
	.globl	_setjmp
	.globl	_longjmp
	.globl	_gouser
	.globl	_osif
	.globl	_xterm
	.globl	_brkpt
	.globl	_oscall
	.globl	_trap13
	.globl	_cinit
	.globl	_run
	.globl	_osinit
	.globl	_tikfrk
	.globl	_dojmp
	.globl	_GSX_ENTRY

_osinit:
	move.l	#_enter,$84		* get trap 1
	move.l	$88,obdos
	move.l	#exit,$88

	move.w	sr,savesr					* SCC  22 Apr 85
	ori.w	#$700,sr					* SCC  14 Apr 85
	move.l	#tikhnd,-(sp)
	move	#$100,-(sp)					* JSL  11 Mar 85
	move	#5,-(sp)
	trap	#13
	add.l	#8,sp
	move.l	d0,otime
	move.w	savesr,sr					* SCC  22 Apr 85
	jsr	_cinit
	rts
*
_trap13: move.l	(sp)+,biosav
	trap	#13
	move.l	biosav,-(sp)
	rts
*
exit:	tst.w	d0
	beq	oterm
*	cmp.w	#$3e,d0						* SCC  11 Mar 85
*	bne	ckgsx						* SCC  11 Mar 85
*	ori.w	#$2000,(sp)					* SCC  11 Mar 85
*	rte							* SCC  11 Mar 85
ckgsx:	cmp.w	#115,d0						* SCC  11 Mar 85
	bne	notgsx
	jsr	_GSX_ENTRY
	rte							* SCC  11 Mar 85

notgsx:
	cmp.w	#-1,d0						* SCC  12 Apr 85
	bne	not_gdos					* SCC  12 Apr 85

	move.l	#_GSX_ENTRY,d0					* SCC  12 Apr 85
	rte							* SCC  12 Apr 85

not_gdos:							* SCC  12 Apr 85
	move.l	obdos,-(sp)
	rts

oterm:	move.l	fsstak,sp
	clr	-(sp)
	jsr	_xterm
*
_brkpt:	illegal
	rte
*
tikhnd:								* SCC  25 Mar 85
	move.w	4(sp),-(sp)					* SCC   1 Apr 85
	jsr	_tikfrk
	addq.l	#2,sp						* SCC   1 Apr 85
	move.l	otime,-(sp)					* SCC  25 Mar 85
	rts
*
_dojmp:	move.l	4(sp),-(sp)
	rts
*
_s68:	link	a6,#0
	move.l	8(a6),a0
	move	(a0),d0
	ror	#8,d0
	move	d0,(a0)
	unlk	a6
	rts

_s68l:	link	a6,#0
	move.l	8(a6),a0
	move.l	(a0),d0
	ror	#8,d0
	swap	d0
	ror	#8,d0
	move.l	d0,(a0)
	unlk	a6
	rts

_setjmp:
	link	a6,#0
	move.l	8(a6),a0
	move.l	0(a6),(a0)+
	lea	8(a6),a1
	move.l	a1,(a0)+
	move.l	4(a6),(a0)
	clr.l	d0
	unlk	a6
	rts

_longjmp:
	link	a6,#0
	move.l	12(a6),d0					* SCC  10 Apr 85
	tst.l	d0						* SCC  10 Apr 85
	bne	okrc

	move	#1,d0
okrc:
	move.l	8(a6),a0
	move.l	(a0)+,a6
	move.l	(a0)+,a7
	move.l	(a0),-(sp)
	rts

* running on global super stack(or users own supstk)/not fs stack
_enter:								* SCC  11 Mar 85
	btst.b	#5,(sp)		* are we in supervisor mode?	* SCC  13 Mar 85
	bne	enter_1		* yes, go check sup stack	* SCC  13 Mar 85

	move.l	usp,a0		* no, check user stack		* SCC  13 Mar 85
	cmp.w	#$20,(a0)	* toggle/inquire state?		* SCC  13 Mar 85
	beq	x20_usr		* yes, go perform function	* SCC  13 Mar 85

	bra	enter_2						* SCC  13 Mar 85

enter_1:							* SCC  13 Mar 85
				* next line is 68000 specific	* SCC  13 Mar 85
	cmp.w	#$20,6(sp)	* toggle/inquire state?		* SCC  13 Mar 85
	beq	x20_sup		* yes, go perform function	* SCC  13 Mar 85

enter_2:							* SCC  13 Mar 85
	move.l	a6,-(sp)					* SCC  11 Mar 85
	move.l	_run,a6
	movem.l	d0/a3-a5,$68(a6)
	move.l	(sp)+,$78(a6)	* olda6
	move	(sp)+,d0	* status reg
	move.l	(sp)+,a4	* retadd
	btst	#13,d0		* if he is in system state, use his stack
	bne	systk
	move.l	usp,a5
	movem.l	d1-d7/a0-a2,-(a5)
	move.l	a4,-(a5)	* retadd
	move	d0,-(a5)	* sr
	move.l	sp,a0
	move.l	a0,-(a5)
	move.l	a5,$7c(a6)
* now switch to fs stack
	move.l	#fstrt,sp
	lea	50(a5),a0
	bra	callos
* he was using his own ssp
systk:	movem.l	d1-d7/a0-a2,-(sp)
	move.l	a4,-(sp)
	move	d0,-(sp)
	move.l	usp,a0
	move.l	a0,-(sp)
	move.l	sp,$7c(a6)
	lea	50(sp),a0
	move.l	#fstrt,sp
callos:	move.l	a0,-(sp)	* push parm pointer
	jsr	_osif
	add.l	#4,sp
*...fall into gouser....
_gouser:move.l	_run,a5
	move.l	d0,$68(a5)
	move.l	$7c(a5),a6	* stack pointer (maybe usp, maybe ssp)
	move.l	(a6)+,a4	* other stack pointer
	move	(a6)+,d0
	move.l	(a6)+,a3	* retadd
	movem.l	(a6)+,d1-d7/a0-a2
	btst	#13,d0
	bne	retsys		* a6 is (user-supplied) system stack
	move.l	a4,sp
	move.l	a6,usp
gousr:	move.l	a3,-(sp)
	move	d0,-(sp)
	movem.l	$68(a5),d0/a3-a6
	rte

retsys:	move.l	a6,sp
	move.l	a4,usp
	bra	gousr

*								* SCC  13 Mar 85
* function 0x20 handler						* SCC  13 Mar 85
* toggle/inquire processor/stack state				* SCC  13 Mar 85
*								* SCC  13 Mar 85

* user mode entry point						* SCC  13 Mar 85

x20_usr:							* SCC  13 Mar 85
	move.l	2(a0),d1	* get parameter			* SCC  13 Mar 85
	beq	xu_0		* already have new SSP from	* SCC  13 Mar 85
*				* old USP, go handle 0L entry	* SCC  13 Mar 85

	subq.l	#1,d1		* check for -1L entry		* SCC  13 Mar 85
	beq	x20_inq		* go handle inquiry		* SCC  13 Mar 85

	move.l	2(a0),a0	* get new SSP from parameter	* SCC  13 Mar 85
xu_0:								* SCC  13 Mar 85
	move.w	(sp)+,d0	* pop SR			* SCC  13 Mar 85
	move.l	(sp)+,-(a0)	* transport the return address	* SCC  13 Mar 85
	ori.w	#$2000,d0	* set supervisor mode		* SCC  13 Mar 85
	move.w	d0,-(a0)	* push SR			* SCC  13 Mar 85
	move.l	sp,d0		* set return value (old SSP)	* SCC  13 Mar 85
	move.l	a0,sp		* set new SSP			* SCC  13 Mar 85
	rte			* and everything is cool	* sCC  13 Mar 85

* supervisor mode entry point					* SCC  13 Mar 85

x20_sup:							* SCC  13 Mar 85
	move.l	8(sp),d1	* get parameter			* SCC  13 Mar 85
	beq	xs_0		* go handle 0L entry		* SCC  13 Mar 85

	subq.l	#1,d1		* check for -1L entry		* SCC  13 Mar 85
	beq	x20_inq		* go handle inquiry		* SCC  13 Mar 85

	move.l	8(sp),a1	* point to new SSP		* SCC  13 Mar 85
	move.w	(sp)+,d0	* pop SR			* SCC  13 Mar 85
	move.l	(sp)+,-(a1)	* transport the return address	* SCC  13 Mar 85
	move.w	d0,-(a1)	* push SR			* SCC  13 Mar 85
	move.l	usp,a0		* get USP			* SCC  13 Mar 85
	cmpa.l	a0,sp		* already at old USP?		* SCC  13 Mar 85
	beq	xs_usp		* don't play with stack		* SCC  13 Mar 85

	move.l	(sp)+,-(a0)	* transport func # and parm	* SCC  13 Mar 85
	move.l	a1,sp		* update SSP			* SCC  13 Mar 85
	bra	xs_exit						* SCC  13 Mar 85

xs_usp:								* SCC  13 Mar 85
	move.l	a1,sp		* update SSP			* SCC  13 Mar 85
	bra	xs_scram					* SCC  13 Mar 85

xs_0:								* SCC  13 Mar 85
	move.l	sp,a0		* create USP			* SCC  13 Mar 85
	addq.l	#6,a0		* this is 68000 specific	* SCC  13 Mar 85
xs_exit:							* SCC  13 Mar 85
	move.l	a0,usp		* update USP			* SCC  13 Mar 85
xs_scram:							* SCC  13 Mar 85
	andi.w	#$DFFF,(sp)	* set user mode			* SCC  13 Mar 85
	rte			* and clear out			* SCC  13 Mar 85

* inquiry mode entry point					* SCC  13 Mar 85

x20_inq:							* SCC  13 Mar 85
	move.l	#$2000,d0	* set up test mask		* SCC  13 Mar 85
	and.w	(sp),d0		* check the supervisor state	* SCC  13 Mar 85
	beq	xi_exit		* return 0L for user mode	* SCC  13 Mar 85

	move.l	#-1,d0		* return -1L for sup mode	* SCC  13 Mar 85
xi_exit:							* SCC  13 Mar 85
	rte							* SCC  13 Mar 85


*
* call dosjr from within itself (or from linked-in shell)
*
_oscall:
	link	a6,#0
	move.l	a0,-(sp)
	lea	8(a6),a0
	move.l	a0,-(sp)
	jsr	_osif
	addq.l	#4,sp
	move.l	(sp)+,a0
	unlk	a6
	rts

	.data

	.even
fsstak:	.dc.l	fstrt
	.bss
	.even
bssstrt: .ds.w	1
biosav:	.ds.l	1
saveret: .ds.l	1
savesr:	.ds.w	1
retshell: .ds.l	1
regsav:	.ds.l	16
	.ds.w	1000
fstrt:	.ds.l	1
otime:	.ds.l	1
obdos:	.ds.l	1
*
	.end

