/*	DESKSUPP.C	05/04/84 - 06/20/85	Lee Lorenzen		*/

/*
*	-------------------------------------------------------------
*	GEM Desktop					  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <taddr.h>
#include <dos.h>
#include <deskdefn.h>
#include <infodef.h>
#include <crysbind.h>
#include <deskapp.h>
#include <deskfpd.h>
#include <deskwin.h>
#include <deskbind.h>

#define ARROW 0
#define HGLASS 2
						/* in DESKFPD.C		*/
EXTERN FNODE	*fpd_ofind();
EXTERN PNODE	*pn_open();
EXTERN WORD	pn_close();
EXTERN WORD	pn_active();
						/* in DESKWIN.C		*/
EXTERN WORD	win_isel();
EXTERN BYTE	*win_iname();
EXTERN WNODE	*win_alloc();
EXTERN WNODE	*win_find();
EXTERN WNODE	*win_ontop();
EXTERN WORD	win_free();
EXTERN VOID	win_bldview();
						/* in DESKAPP.C		*/
EXTERN WORD	app_blddesk();
EXTERN ANODE	*app_afind();
						/* in DESKACT.C		*/
EXTERN WORD	act_chg();
EXTERN WORD	act_allchg();
						/* in DESKINF.C		*/
EXTERN WORD	inf_file();
						/* in DESKTOP.C		*/
EXTERN ANODE	*i_find();

EXTERN BYTE	*ini_str();

EXTERN LONG	dos_alloc();
EXTERN LONG	dos_avail();
EXTERN WORD	dos_free();

EXTERN WORD	DOS_ERR;
EXTERN GRECT	gl_rfull;
EXTERN WORD	gl_apid;

EXTERN GLOBES	G;

/*
*	Clear out the selections for this particular window
*/

desk_clear(wh)
	WORD		wh;
{
	WNODE		*pw;
	GRECT		c;
	WORD		root;

						/* get current size	*/
	wind_get(wh, WF_WXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
						/* find its tree of 	*/
						/*   items		*/
	if (wh != 0)
	{
	  pw = win_find(wh);
	  root = pw->w_root;
	}
	else
	{
	  root = DROOT;
	}
						/* clear all selections	*/
	act_allchg(wh, G.a_screen, root, 0, &gl_rfull, &c,
		 SELECTED, FALSE, TRUE, TRUE);
}

/*
*	Verify window display by building a new view.
*/
	WORD
desk_verify(wh, changed)
	WORD		wh;
	WORD		changed;
{
	WNODE		*pw;
	WORD		xc, yc, wc, hc;

						/* get current size	*/
	if (wh)
	{
	  pw = win_find(wh);
	  if (changed)
	  {
	    wind_get(wh, WF_WXYWH, &xc, &yc, &wc, &hc);
	    win_bldview(pw, xc, yc, wc, hc);
	  }
	  G.g_croot = pw->w_root;
	}
	else
	{
	  G.g_croot = DROOT;
	}
	G.g_cwin = wh;
}


	WORD
do_wredraw(w_handle, xc, yc, wc, hc)
	WORD		w_handle;
	WORD		xc, yc, wc, hc;
{
	GRECT		t;
	WNODE		*pw;
	LONG		tree;
	WORD		root;

	tree = G.a_screen;
	if (w_handle != 0)
	{
	  pw = win_find(w_handle);
	  root = pw->w_root;
	}
	else
	{
	  root = DROOT;
	}

	graf_mouse(M_OFF, 0x0L);

	wind_get(w_handle, WF_FIRSTXYWH, &t.g_x, &t.g_y, &t.g_w, &t.g_h);
	while ( t.g_w && t.g_h )
	{
	  if ( rc_intersect(&xc, &t) )
	    objc_draw(tree, root, MAX_DEPTH, t.g_x, t.g_y, t.g_w, t.g_h);
	  wind_get(w_handle, WF_NEXTXYWH, &t.g_x, &t.g_y, &t.g_w, &t.g_h);
	}
	graf_mouse(M_ON, 0x0L);
}


/*
*	Picks ob_x, ob_y, ob_width, ob_height fields out of object list.
*/

	VOID
get_xywh(olist, obj, px, py, pw, ph)
	OBJECT		olist[];
	WORD		obj;
	WORD		*px, *py, *pw, *ph;
{
	*px = olist[obj].ob_x;
	*py = olist[obj].ob_y;
	*pw = olist[obj].ob_width;
	*ph = olist[obj].ob_height;
}

/*
*	Picks ob_spec field out of object list.
*/

	LONG
get_spec(olist, obj)
	OBJECT		olist[];
	WORD		obj;
{
	return( olist[obj].ob_spec );
}


do_xyfix(px, py)
	WORD		*px, *py;
{
	WORD		tx, ty, tw, th;

	wind_get(0, WF_WXYWH, &tx, &ty, &tw, &th);
	tx = *px;
	*px = (tx & 0x000f);
	if ( *px < 8 )
	  *px = tx & 0xfff0;
	else
	  *px = (tx & 0xfff0) + 16;
	*py = max(*py, ty);
}


do_wopen(new_win, wh, curr, x, y, w, h)
	WORD		new_win;
	WORD		wh;
	WORD		curr;
	WORD		x, y, w, h;
{
	WNODE		*pw;
	WORD		ix, iy, iw, ih;
	GRECT		c;

	do_xyfix(&x, &y);
	get_xywh(G.g_screen, curr, &ix, &iy, &iw, &ih);
	get_xywh(G.g_screen, G.g_croot, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
	ix += c.g_x;
	iy += c.g_y;
	graf_growbox(ix, iy, iw, ih, x, y, w, h);
	act_chg(G.g_cwin, G.a_screen, G.g_croot, curr, &c, SELECTED, 
			FALSE, TRUE, TRUE);
	if (new_win)
	  wind_open(wh, x, y, w, h);

	G.g_wlastsel = wh;
}


do_wclose(old_win, wh, org_x, org_y)
	WORD		old_win;
	WORD		wh;
	WORD		org_x, org_y;
{
	WORD		x, y, w, h;

	wind_get(wh, WF_WXYWH, &x, &y, &w, &h);
	  
	if (old_win)
	  wind_close(wh);

	graf_shrinkbox(org_x, org_y, G.g_wicon, G.g_hicon, x, y, w, h);
}


do_wfull(wh)
	WORD		wh;
{
	GRECT		c, p, f;

	wind_get(wh, WF_CXYWH, &c.g_x, &c.g_y, &c.g_w, &c.g_h);
	wind_get(wh, WF_PXYWH, &p.g_x, &p.g_y, &p.g_w, &p.g_h);
	wind_get(wh, WF_FXYWH, &f.g_x, &f.g_y, &f.g_w, &f.g_h);

	if ( rc_equal(&c, &f) )
	{
						/* is full now so change*/
						/*   to previous	*/
	  wind_set(wh, WF_CXYWH, p.g_x, p.g_y, p.g_w, p.g_h);
	  graf_shrinkbox(p.g_x, p.g_y, p.g_w, p.g_h,
				 f.g_x, f.g_y, f.g_w, f.g_h);
	}
	else
	{
						/* is not full so make	*/
						/*   it full		*/
	  graf_growbox(c.g_x, c.g_y, c.g_w, c.g_h,
				 f.g_x, f.g_y, f.g_w, f.g_h);
	  wind_set(wh, WF_CXYWH, f.g_x, f.g_y, f.g_w, f.g_h);
	}
}

/*
*	Open a directory, it may be the root or a subdirectory.
*/

	WORD
do_diropen(pw, new_win, curr_icon, drv, ppath, pname, pext, pt)
	WNODE		*pw;
	WORD		new_win;
	WORD		curr_icon;
	WORD		drv;
	BYTE		*ppath, *pname, *pext;
	GRECT		*pt;
{
	WORD		ret;
						/* convert to hourglass	*/
	graf_mouse(HGLASS, 0x0L);
						/* open a path node	*/
	pw->w_path = pn_open(drv, ppath, pname, pext, F_SUBDIR);
						/* activate path by 	*/
						/*   search and sort	*/
						/*   of directory	*/
	ret = pn_active(pw->w_path);
	if ( ret != E_NOFILES )
	{
						/* some error condition	*/
	}
						/* set new name and info*/
						/*   lines for window	*/
	win_sname(pw);
	win_sinfo(pw);
	wind_set(pw->w_id, WF_NAME, ADDR(&pw->w_name[0]), 0, 0);
	wind_set(pw->w_id, WF_INFO, ADDR(&pw->w_info[0]), 0, 0);
						/* show expanding window*/
						/*   from icon and do	*/
						/*   actual window open	*/
	if ( curr_icon > 0 )
	{
	  do_wopen(new_win, pw->w_id, curr_icon, 
				pt->g_x, pt->g_y, pt->g_w, pt->g_h);
	  if (new_win)
	    win_top(pw);
	}
						/* verify contents of	*/
						/*   windows object list*/
						/*   by building view	*/
						/*   and make it curr.	*/
	desk_verify(pw->w_id, TRUE);
						/* make it redraw	*/
	if ( !new_win )
	{
	  fun_msg(WM_REDRAW, gl_apid, pw->w_id, 
		pt->g_x, pt->g_y, pt->g_w, pt->g_h);
	}
	graf_mouse(ARROW, 0x0L);

	return(TRUE);
}


/*
*	Open an application
*/

	WORD
do_aopen(pa, isapp, curr, drv, ppath, pname)
	ANODE		*pa;
	WORD		isapp;
	WORD		curr;
	WORD		drv;
	BYTE		*ppath;
	BYTE		*pname;
{
	WORD		ret, done;
	WORD		isgraf, isover, isparm, uninstalled;
	WORD		xc, yc, wc, hc;
	WORD		ix, iy, iw, ih;
	BYTE		*ptmp, *pcmd, *ptail;
	BYTE		name[13];

	get_xywh(G.g_screen, curr, &ix, &iy, &iw, &ih);
	get_xywh(G.g_screen, G.g_croot, &xc, &yc, &wc, &hc);
	ix += xc;
	iy += yc;

	done = FALSE;
						/* set flags		*/
	isgraf = pa->a_flags & AF_ISGRAF;
	isover = (pa->a_flags & AF_ISFMEM) ? 2 : 1;
	isover = -1;
	isparm = pa->a_flags & AF_ISPARM;
	uninstalled = ( (*pa->a_pappl == '*') || 
			(*pa->a_pappl == '?') ||
			(*pa->a_pappl == NULL) );
						/* change current dir.	*/
						/*   to selected icon's	*/
	pro_chdir(drv, ppath);
						/* see if application	*/
						/*   was selected 	*/
						/*   directly or a 	*/
						/*   data file with an	*/
						/*   associated primary	*/
						/*   application	*/
	pcmd = ptail = NULLPTR;
	G.g_cmd[0] = G.g_tail[1] = NULL;
	ret = TRUE;

	if ( (!uninstalled)  &&
	     (!isapp) )
	{
						/* an installed	docum.	*/
	  pcmd = pa->a_pappl;
	  ptail = pname;
	}
	else
	{
	  if ( isapp )
	  {
						/* DOS-based app. has	*/
						/*   been selected	*/
	    if (isparm)
	    {
	      pcmd = &G.g_cmd[0];
	      ptail = &G.g_tail[1];
	      ret = opn_appl(pname, "\0", pcmd, ptail);
	    }
	    else
	      pcmd = pname;
	  }
	  else
	  {
						/* DOS-based document 	*/
						/*   has been selected	*/
	    fun_alert(1, ST_NOAPPL, NULLPTR);
	    ret = FALSE;
	  }
	}
						/* see if it is a 	*/
						/*   batch file		*/
	if ( wildcmp( ini_str(ST_GEMBAT), pcmd) )
	{
						/* if is app. then copy	*/
						/*   typed in parameter	*/
						/*   tail, else it was	*/
						/*   a document installed*/
						/*   to run a batch file*/
	  strcpy( (isapp) ? &G.g_tail[1] : ptail, &G.g_1text[0]);
	  ptmp = &name[0];
	  pname = pcmd;
	  while ( *pname != '.' )
	    *ptmp++ = *pname++;
	  *ptmp = NULL;
	  ret = do_cmd(&name[0], &G.g_1text[0], TRUE);
	  pcmd = &G.g_cmd[0];
	  ptail = &G.g_tail[1];
	}
						/* user wants to run	*/
						/*   another application*/
	if (ret)
	{
	  if ( (pcmd != &G.g_cmd[0]) &&
	       (pcmd != NULLPTR) )
	    strcpy(pcmd, &G.g_cmd[0]);
	  if ( (ptail != &G.g_tail[1])  &&
	       (ptail != NULLPTR) )
	    strcpy(ptail, &G.g_tail[1]);
	  done = do_run(isgraf, isover, G.g_cwin, curr);
	}
	return(done);
}


/*
*	Open a disk
*/

	WORD
do_dopen(curr)
	WORD		curr;
{
	WORD		ret;
	WORD		done;
	WORD		drv;
	WNODE		*pw;
	ICONBLK		*pib;

	done = FALSE;

	pib = (ICONBLK *) get_spec(G.g_screen, curr);
	pw = win_alloc(curr);
	if (pw)
	{
	  drv = (0x00ff & pib->ib_char);
	  pro_chdir(drv, "");
	  if (!DOS_ERR)
 	    do_diropen(pw, TRUE, curr, drv, "", "*", "*", 
			&G.g_screen[pw->w_root].ob_x);
	  else
	    win_free(pw);
	}
	else
	{
	  rsrc_gaddr(R_STRING, ST_NOWIND, &G.a_alert);
	  ret = form_alert(1, G.a_alert);
	}
	return( done );
}


/*
*	Open a folder
*/
	WORD
do_fopen(pw, curr, drv, ppath, pname, pext)
	WNODE		*pw;
	WORD		curr;
	WORD		drv;
	BYTE		*ppath, *pname, *pext;
{
	WORD		ret;
	WORD		done;
	GRECT		t;

	done = FALSE;

	wind_get(pw->w_id, WF_WXYWH, &t.g_x, &t.g_y, &t.g_w, &t.g_h);
	pro_chdir(drv, "");
	if (!DOS_ERR)
	{
	  pro_chdir(drv, ppath);
	  pn_close(pw->w_path);
	  if (DOS_ERR)
	  {
	    ppath = "";
	    pname = "*";
	    pext  = "*";
	  }
	  do_diropen(pw, FALSE, curr, drv, ppath, pname, pext, &t);
	}
	else
	  do_dclose(pw);

	return(done);
}


/*
*	Open an icon
*/

	WORD
do_open(curr)
	WORD		curr;
{
	WORD		done;
	ANODE		*pa;
	WNODE		*pw;
	FNODE		*pf;
	WORD		drv, isapp;
	BYTE		path[65], name[9], ext[4];

	done = FALSE;

	pa = i_find(G.g_cwin, curr, &pf, &isapp);
	if (G.g_cwin == 0)
	  drv = 0;
	else
	{
	  pw = win_find(G.g_cwin);
	  if ( pf )
	    fpd_parse(&pw->w_path->p_spec[0],&drv,&path[0],&name[0],&ext[0]);
	}

	if ( pa )
	{	
	  switch( pa->a_type )
	  {
	    case AT_ISFILE:
		done = do_aopen(pa, isapp, curr, drv, &path[0],
					&pf->f_name[0]);
		break;
	    case AT_ISFOLD:
		if (path[0] != NULL)
		  strcat("\\", &path[0]);
		strcat(&pf->f_name[0], &path[0]);
		done = do_fopen(pw, curr, drv, &path[0], &name[0], &ext[0]);
		break;
	    case AT_ISDISK:
		done = do_dopen(curr);
		break;
	    case AT_ISTRSH:
	        rsrc_gaddr(R_STRING, ST_NOOPEN, &G.a_alert);
		form_alert(1, G.a_alert);
		break;
	  }
	}

	return(done);
}



/*
*	Get information on an icon.
*/

	WORD
do_info(curr)
	WORD		curr;
{
	WORD		done, ret, junk;
	ANODE		*pa;
	WNODE		*pw;
	FNODE		*pf;
	ICONBLK		*pib;
	LONG		tree;

	done = FALSE;
	
	pa = i_find(G.g_cwin, curr, &pf, &junk);
	if (G.g_cwin != 0)
	  pw = win_find(G.g_cwin);

	if ( pa )
	{	
	  switch( pa->a_type )
	  {
	    case AT_ISFILE:
		ret = inf_file(&pw->w_path->p_spec[0], pf);
		if (ret)
		  fun_rebld(pw);
		break;
	    case AT_ISFOLD:
		inf_folder(&pw->w_path->p_spec[0], pf);
		break;
	    case AT_ISDISK:
		pib = (ICONBLK *) get_spec(G.g_screen, curr);
		inf_disk( (0x00ff & pib->ib_char));
		break;
	    case AT_ISTRSH:
		tree = G.a_trees[AD_TRSHINFO];
		inf_show(tree, 0);
		LWSET(OB_STATE(TRSH_OK), NORMAL);
		break;
	  }
	}
	return(done);
}

/*
*	This routines purpose is to format a disk by execing a
*	FORMAT.COM above us in memory.  Unfortunately, the ROM BIOS
*	has a bug of using the contents of FORMAT's PSP while doing
*	a Disk Verify function using INT 13h.  This forces us to 
*	place the FORMAT we exec into a safe location in memory.
*	The safe location is an address with segment values between
*	x00x and xEDx. We fudge this on both side by 400 paragraphs.
*	Thanks alot, Bill and Phil.
*/
	VOID
romerr(curr)
	WORD		curr;
{
	UWORD		seg;
	LONG		testform, lavail;

	lavail = dos_avail();
	testform = dos_alloc( lavail );
	seg = testform >> 16;
	dos_free(testform);
	testform = 0x0L;
	if ( ((seg << 4) & 0xff00) >= 0xe900)
	  testform = dos_alloc( 0x00001b00L );
	do_run(FALSE, 0, -1, curr);
	if (testform)
	  dos_free(testform);
}

/*
*	Format the currently selected disk.
*/

	WORD
do_format(curr)
	WORD		curr;
{
	WORD		done, isapp, ret, wtemp[1];
	BYTE		*pname, *psrc, *ptmp, msg[6];
	ANODE		*pa;
	ICONBLK		*pib;

	done = FALSE;

	pa = (ANODE *) NULL;
	if (G.g_cwin == 0)
	{
	  pname = win_iname(curr);
	  pa = app_afind(TRUE, -1, curr, pname, &isapp);
	}

	if ( pa )
	{	
	  switch( pa->a_type )
	  {
	    case AT_ISDISK:
		pib = (ICONBLK *) get_spec(G.g_screen, curr);
		msg[0] = (0x00ff & pib->ib_char) ;
		msg[1] = NULL;
		wtemp[0] = (UWORD) &msg[0];
		ret = fun_alert(2, ST_FORMAT, &wtemp);
		strcpy(":", &msg[1]);
	        if (ret == 1)
		{
		  strcpy( ini_str(ST_DKFORM), &G.g_cmd[0]);
		  if ( shel_find(G.a_cmd) )
		  {
		    strcpy(&msg[0], &G.g_tail[1]);
		    takedos();
		    takekey();
		    takevid();
		    romerr(curr);
		    givevid();
		    givekey();
		    givedos();
		  }
		  graf_mouse(ARROW, 0x0L);	
		}
		break;
	  }
	}
	return(done);
}

/*
*	Routine to check the top windows directory by doing a change
*	disk/directory to it and redrawing the window;
*/

do_chktop()
{
	WNODE		*pw;
	WORD		drv;
	BYTE		path[65], name[9], ext[4];

	pw = win_ontop();
	if (pw)
	{
	  G.g_wlastsel = pw->w_id;
	  fpd_parse(&pw->w_path->p_spec[0], &drv, &path[0],
		&name[0], &ext[0]);
	  do_fopen(pw, 0, drv, &path[0], &name[0], &ext[0]);
	}
	else
	{
	  G.g_wlastsel = 0;
	  desk_verify(0, TRUE);
	}
}


/*
*	Close the top disk window back into an icon
*/

	WORD
do_dclose(pw)
	WNODE		*pw;
{
	WORD		ret;
	WORD		done;
	WORD		x, y, w, h;

	done = FALSE;

	wind_get(pw->w_id, WF_WXYWH, &x, &y, &w, &h);
	do_wclose(TRUE, pw->w_id, G.g_screen[pw->w_obid].ob_x,
			G.g_screen[pw->w_obid].ob_y);

	pn_close(pw->w_path);
	win_free(pw);

	do_chktop();

	return(done);
}


/*
*	Close the top folder window back into itself
*/
	WORD
do_fclose(pw, drv, ppath, pname, pext)
	WNODE		*pw;
	WORD		drv;
	BYTE		*ppath, *pname, *pext;
{
	WORD		ret;
	WORD		done;
	GRECT		t;
	WORD		xi, yi;

	done = FALSE;

	wind_get(pw->w_id, WF_WXYWH, &t.g_x, &t.g_y, &t.g_w, &t.g_h);

	xi = t.g_x + (t.g_w/2) - (G.g_wicon/2);
	yi = t.g_y + (t.g_h/2) - (G.g_hicon/2);
	do_wclose(FALSE, pw->w_id, xi, yi);

	do_fopen(pw, 0, drv, ppath, pname, pext);
	return(done);
}


/*
*	Close a window back into a folder or a disk.
*/

	WORD
do_close(pw, do_all)
	WNODE		*pw;
	WORD		do_all;
{
	WORD		done;
	WORD		drv;
	BYTE		path[65], name[9], ext[4];
	BYTE		*pbeg, *pend;

	done = FALSE;
	graf_mouse(HGLASS, 0x0L);	

	fpd_parse(&pw->w_path->p_spec[0], &drv, &path[0], &name[0], &ext[0]);

	if (do_all)
	  path[0] = NULL;

	if (path[0] == NULL)
	{
						/* No more path so 	*/
						/*   close the root and	*/
						/*   the disk with it	*/
	  done = do_dclose(pw);
	}
	else
	{
						/* Some path left so	*/
						/*   scan off last	*/
						/*   directory and open	*/
						/*   the parent		*/
	  pbeg = pend = &path[0];
	  pend += (strlen(&path[0]) - 1);
						/* Remove last name	*/
	  while ( (pend != pbeg) &&
		  (*pend != '\\') )
	    pend--;
						/* Scan off trailing	*/
						/*   slash		*/
	  *pend = NULL;
	  done = do_fclose(pw, drv, &path[0], &name[0], &ext[0]);
	}

	graf_mouse(ARROW, 0x0L);	

	return(done);
}

