/*	DESKINS.C	09/22/84 - 06/19/85	Lee Lorenzen		*/

/*
*	-------------------------------------------------------------
*	GEM Desktop					  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <taddr.h>
#include <deskdefn.h>
#include <dos.h>
#include <deskapp.h>
#include <deskfpd.h>
#include <deskwin.h>
#include <infodef.h>
#include <crysbind.h>
#include <deskbind.h>
							/* in DESKAPP.C	*/
EXTERN ANODE	*app_alloc();
EXTERN VOID	app_free();
EXTERN BYTE	*scan_str();
EXTERN BYTE	*scasb();
EXTERN BYTE	*ini_str();

EXTERN WORD	gl_width;
EXTERN WORD	gl_height;

EXTERN WORD	gl_hchar;

EXTERN WORD	gl_hbox;
EXTERN BYTE	gl_lngstr[256];
EXTERN WORD	gl_pstart;
EXTERN WORD	gl_numics;

EXTERN GLOBES	G;

GLOBAL ICONBLK	gl_aib;
GLOBAL ICONBLK	gl_dib;


/*
*	Routine to tell if an icon has an associated document type.
*/
	WORD
is_installed(pa)
	ANODE		*pa;
{
	return ( !((*pa->a_pappl == '*') || 
		   (*pa->a_pappl == '?') ||
		   (*pa->a_pappl == NULL)  ) );
}


/*
*	Routine to find out if this icon is the last disk icon on the
*	screen.
*/
	WORD
lastdisk()
{
	WORD 		i;
	ANODE		*pa;

	i = 0;
	for(pa=G.g_ahead; pa; pa=pa->a_next)
	{
	  if (pa->a_type == AT_ISDISK)
	    i++;
	}
	return( (i < 2) );
}


/*
*	Routine to place disk icon between the current disk icon and
*	the trash can
*/

ins_posdisk(dx, dy, pdx, pdy)
	WORD		dx, dy;
	WORD		*pdx, *pdy;
{
	WORD		tx, ty;
	WORD		xdiff, ydiff, xdir, ydir;
	ANODE		*pa;

	for(pa=G.g_ahead; pa; pa=pa->a_next)
	{
	  if (pa->a_type == AT_ISTRSH)
	  {
	    tx = pa->a_xspot;
	    ty = pa->a_yspot;
	    break;
	  }
	}

	xdiff = tx - dx;
	ydiff = ty - dy;

	xdir = (xdiff < 0) ? -1 : 1;
	ydir = (ydiff < 0) ? -1 : 1;

	xdiff *= xdir;
	ydiff *= ydir;

	if (ydiff > xdiff)
	{
	  *pdx = dx;
	  *pdy = dy + (G.g_ich * ydir);
	}
	else
	{
	  *pdx = dx + (G.g_icw * xdir);
	  *pdy = dy;
	}
}

/*
*	Routine to find out if there is another icon with this letter already
*	on the desktop.
*/
	ANODE
*get_disk(letter)
	WORD		letter;
{
	ANODE		*pa;

	for(pa=G.g_ahead; pa; pa=pa->a_next)
	{
	  if ((pa->a_type == AT_ISDISK) &&
	      (pa->a_letter == letter) )
	    return(pa);
	}
	return( 0 );
}

/************************************************************************/
/* i n s _ d i s k							*/
/************************************************************************/
	WORD
ins_disk(pa)
	ANODE		*pa;
{			       
	WORD		change;
	LONG		tree, spec;
	BYTE		cletter[2], clabel[13];
	BYTE		nletter[2], nlabel[13];
	ANODE		*newpa, *tmp;
	WORD		type, icon, flop, hard, obid, field;

	tree = G.a_trees[AD_INSDISK];

	change = FALSE;
	cletter[0] = pa->a_letter;
	cletter[1] = NULL;
	strcpy(pa->a_pappl, &clabel[0]);

	inf_sset(tree, DR_ID, &cletter[0]);
	inf_sset(tree, DR_LABEL, &clabel[0]);

	flop = (pa->a_aicon == IG_FLOPPY) ? SELECTED : NORMAL;
	hard = (pa->a_aicon == IG_HARD) ? SELECTED : NORMAL;
	LWSET(OB_STATE(DR_FLOPPY), flop);
	LWSET(OB_STATE(DR_HARD), hard);

	LWSET(OB_STATE(DR_REM), (lastdisk()) ? DISABLED : NORMAL ); 

	inf_show(tree, 0);	

	inf_sget(tree, DR_ID, &nletter[0]);
	inf_sget(tree, DR_LABEL, &nlabel[0]);
	icon = ( LWGET(OB_STATE(DR_FLOPPY)) & SELECTED );
	icon = (icon) ? IG_FLOPPY : IG_HARD;

	field = inf_gindex(tree, DR_INST, 3);
	LWSET(OB_STATE(DR_INST + field), NORMAL);

	if ( field == 0 )
	{
	  if (cletter[0] != nletter[0])
	  {
	    newpa = get_disk(nletter[0]);
	    if (!newpa)
	    {
	      newpa = app_alloc(FALSE);
	      if (newpa)
	      {
	        newpa->a_flags = pa->a_flags;
	        newpa->a_type = pa->a_type;
  	        newpa->a_obid = pa->a_obid;
	        newpa->a_pappl = pa->a_pappl;
		scan_str("@", &newpa->a_pdata);
	        newpa->a_aicon = pa->a_aicon;
   	        newpa->a_dicon = NIL;
  	        newpa->a_letter = nletter[0];
		ins_posdisk(pa->a_xspot, pa->a_yspot,
			&newpa->a_xspot, &newpa->a_yspot);
	        app_posicon(newpa->a_xspot, newpa->a_yspot, 
				&newpa->a_xspot, &newpa->a_yspot);
	      }
	      else
	        fun_alert(1, ST_APGONE, NULLPTR);
	    }
	    if (newpa)
	      pa = newpa;
	    change = TRUE;
	  }
						/* see if icon changed	*/
	  if (pa->a_aicon != icon)
	  {
	    pa->a_aicon = icon;
	    change = TRUE;
	  }
						/* see if label changed	*/
	  if ( !strcmp(&clabel[0], &nlabel[0]) )
	  {
	    nlabel[ strlen(&nlabel[0]) ] = '@';
	    scan_str(&nlabel[0], &pa->a_pappl);
	    change = TRUE;
	  }
	} /* if INSTALL */
	else if ( field == 1 )
	{
						/* find matching anode	*/
						/*   delete it		*/
	  for(pa=G.g_ahead; pa; pa=pa->a_next)
	  {
	    if ( (pa->a_aicon == icon)  &&
		 (pa->a_letter == nletter[0]) )
	    {
	      app_free(pa);
	      change = TRUE;
	    }
	  }
	} /* if REMOVE */

	return(change);
} /* ins_disk */


insa_icon(tree, obj, nicon, pic, ptext)
	LONG		tree;
	WORD		obj;
	WORD		nicon;
	ICONBLK		*pic;
	BYTE		*ptext;
{
	movs(sizeof(ICONBLK), &G.g_iblist[nicon], pic);
	pic->ib_ptext = ADDR( ptext );
	LWSET(OB_TYPE(obj), G_ICON);
	LLSET(OB_SPEC(obj), ADDR(pic));
}


	VOID
insa_elev(tree, nicon, numics)
	LONG		tree;
	WORD		nicon;
	WORD		numics;
{
	WORD		y, h, th;
	BYTE		*pstr;
	LONG		lp;

	y = 0;
	th = h = LWGET(OB_HEIGHT(AP_FSVSLID));  
	if ( numics > 1)
	{
	  h = mul_div(1, h, numics);
	  h = max((gl_hbox/2)+2, h);		/* min size elevator	*/
	  y = mul_div(nicon, th-h, numics-1);
	}
	LWSET(OB_Y(AP_FSVELEV), y);
	LWSET(OB_HEIGHT(AP_FSVELEV), h);

	strcpy(	ini_str(ST_APPL), &G.g_1text[0] );
	insa_icon(tree, AP_F1NAME, IA_GENERIC+nicon, &gl_aib, &G.g_1text[0]);

	strcpy(	ini_str(ST_DOCU), &G.g_2text[0] );
	insa_icon(tree, AP_F2NAME, ID_GENERIC+nicon, &gl_dib, &G.g_2text[0]);

	lp = G.a_datastart + LWGET(G.a_datastart + gl_pstart + (nicon*2));
	LSTCPY(ADDR(&gl_lngstr[0]), lp);
	inf_sset(tree, AP_FTITLE, &gl_lngstr[0] );
}


	WORD
insa_dial(tree, nicon, numics)
	LONG		tree;
	WORD		nicon;
	WORD		numics;
{
	WORD		firstslot, nstate, ystate, i;
	WORD		touchob, oicon, value;
	WORD		mx, my, kret, bret;
	WORD		cont, xoff, yoff;
	BYTE		*pstr, doctype[4];
						/* draw the form	*/
	show_box(tree);
						/* init for while loop	*/
						/*   by forcing initial	*/
						/*   fs_newdir call	*/
	cont = TRUE;
	while( cont )
	{
	  firstslot = 6;
	  for(i=0; i<firstslot; i++)
	  {
	    pstr = &doctype[0];
	    inf_sget(tree, AP_DFTYPE+i, pstr);
	    if (*pstr == NULL)
	      firstslot = i;
	  }
	  touchob = form_do(tree, AP_DFTYPE+firstslot);
	  graf_mkstate(&mx, &my, &kret, &bret);
	
	  value = nstate = ystate = 0;
	  touchob &= 0x7fff;
	  switch( touchob )
	  {
	    case AP_INST:
	    case AP_REMV:
	    case AP_CNCL:
		cont = FALSE;
		break;
	    case AP_FUPAROW:
		value = -1;
		break;
	    case AP_FDNAROW:
		value = 1;
		break;
	    case AP_GEM:
		nstate = SELECTED;
		ystate = DISABLED;
		break;
	    case AP_DOS:
	    case AP_PARMS:
		nstate = LWGET(OB_STATE(AP_NMEM));
		ystate = LWGET(OB_STATE(AP_YMEM));
		if ( ystate == DISABLED )
		{
		  nstate = SELECTED;
		  ystate = NORMAL;
		}
		break;
	    case AP_FSVSLID:
		objc_offset(tree, AP_FSVELEV, &xoff, &yoff);		
		value = (my <= yoff) ? -1 : 1;
		break;
	    case AP_FSVELEV:
		wind_update(3);
		value = graf_slidebox(tree, AP_FSVSLID, AP_FSVELEV, TRUE);
		wind_update(2);
		value = mul_div(value, numics-1, 1000) - nicon;
		break;
	  }
	  if (nstate != ystate)
	  {
	    LWSET(OB_STATE(AP_NMEM), nstate);
	    LWSET(OB_STATE(AP_YMEM), ystate);
	    draw_fld(tree, AP_MEMBOX);
	  }
	  if (value)
	  {
	    oicon = nicon;
	    nicon += value;
	    if (nicon < 0)
	      nicon = 0;
	    if (nicon >= numics)
	      nicon = numics - 1;	
	    if (oicon != nicon)
	    {
	      insa_elev(tree, nicon, numics);
	      draw_fld(tree, AP_FTITLE);
	      draw_fld(tree, AP_FSVSLID);
	      draw_fld(tree, AP_FILEBOX);
	    }
	  }
	}
						/* undraw the form	*/
	hide_box(tree);
	return(nicon);
}


insa_gtypes(tree, ptypes)
	LONG		tree;
	BYTE		*ptypes;
{
	WORD		i, j;
	BYTE		*pstr, doctype[4];

	j = 0;
	*ptypes = NULL;
	for(i=0; i<8; i++)
	{
	  pstr = &doctype[0];
	  inf_sget(tree, AP_DFTYPE+i, pstr);
	  if (*pstr)
	  {
	    if (j != 0)
	      ptypes[j++] = ','; 
	    strcpy("*.*", &ptypes[j]);
	    strcpy(pstr, &ptypes[j+2]);
	    j += 2 + strlen(pstr);
	  }
	}
}


insa_stypes(tree, pdata)
	LONG		tree;
	BYTE		*pdata;
{
	WORD		i;
	BYTE		*pstr, doctype[4];

	for(i=0; i<8; i++)
	{
	  pdata = scasb(pdata, '.');
	  if (*pdata == '.')
	    pdata++;
	  pstr = &doctype[0];
	  while ( (*pdata) &&
		  (*pdata != ',') )
	    *pstr++ = *pdata++;
	  *pstr = NULL;
	  inf_sset(tree, AP_DFTYPE+i, &doctype[0]);
	}
}


/************************************************************************/
/* i n s _ a p p	  						*/
/************************************************************************/
	WORD
ins_app(pfname, pa)
	BYTE		*pfname;
	ANODE		*pa;
{			       
	LONG		tree;
	ANODE		*newpa;
	BYTE		*pstr;
	BYTE		pname[12];
	BYTE		ntypes[6*8];
	BYTE		doctype[4];
	WORD		oicon, nicon;
	WORD		oflag, nflag;
	WORD		change, field;
	WORD		i, uninstalled, h;

	tree = G.a_trees[AD_INSAPP];
	h = LWGET(OB_HEIGHT(AP_SCRLBAR));
	LWSET(OB_HEIGHT(AP_FUPAROW), gl_hbox + 2);
	LWSET(OB_Y(AP_FSVSLID), gl_hbox + 2);
	LWSET(OB_HEIGHT(AP_FSVSLID), h - (2 * (gl_hbox + 2)));
	LWSET(OB_Y(AP_FDNAROW), h - (gl_hbox + 2));
	LWSET(OB_HEIGHT(AP_FDNAROW), gl_hbox + 2);

	uninstalled = !is_installed(pa);
	LWSET(OB_STATE(AP_REMV), (uninstalled) ? DISABLED : NORMAL );
						/* stuff in appl name	*/
	fmt_str(pfname, &pname[0]);
	inf_sset(tree, AP_NAME, &pname[0]);
						/* stuff in docu types	*/
	insa_stypes(tree, pa->a_pdata);

	oflag = pa->a_flags;
	if (pa->a_flags & AF_ISCRYS)
	{
	  field = AP_GEM;
	  LWSET(OB_STATE(AP_YMEM), DISABLED);
	}
	else
	  field = (pa->a_flags & AF_ISPARM) ? AP_PARMS : AP_DOS;
	LWSET(OB_STATE(field), SELECTED);

	field = (pa->a_flags & AF_ISFMEM) ? AP_YMEM : AP_NMEM;
	LWSET(OB_STATE(field), SELECTED);

	oicon = pa->a_aicon - IA_GENERIC;

	insa_elev(tree, oicon, gl_numics);
	nicon = insa_dial(tree, oicon, gl_numics);
	change = FALSE;
						/* set memory flag	*/
	field = inf_gindex(tree, AP_YMEM, 2);
	nflag = (field == 0) ? AF_ISFMEM : 0;
	LWSET(OB_STATE(AP_YMEM + field), NORMAL);
						/* set type flags	*/
	field = inf_gindex(tree, AP_GEM, 3);
	if (field == 0)
	  nflag = AF_ISCRYS | AF_ISGRAF;
	if (field == 2)
	  nflag |= AF_ISPARM;
	LWSET(OB_STATE(AP_GEM + field), NORMAL);
						/* get button selection	*/
	field = inf_gindex(tree, AP_INST, 3);
	LWSET(OB_STATE(AP_INST + field), NORMAL);

	if ( field == 0 )
	{
						/* install the appl.	*/
						/*   if its uninstalled	*/
						/*   or has new types	*/
	  insa_gtypes(tree, &ntypes[0]);
	  if ( (uninstalled) ||
	       (!strcmp(&ntypes[0], pa->a_pdata)) )
	  {
	    newpa = (uninstalled) ? app_alloc(TRUE) : pa;

	    if (newpa)
	    {
	      if ( (uninstalled) ||
		   (!strcmp(&ntypes[0], pa->a_pdata)) )
	      {
		change = TRUE;
	        ntypes[ strlen(&ntypes[0]) ] = '@';
	        scan_str(&ntypes[0], &newpa->a_pdata);
	      }

	      if (newpa != pa)
	      {
		uninstalled = change = TRUE;
	        strcpy(pfname, &ntypes[0]);
	        ntypes[ strlen(&ntypes[0]) ] = '@';
	        scan_str(&ntypes[0], &newpa->a_pappl);
	        newpa->a_flags = nflag;
	        newpa->a_type = AT_ISFILE;
	        newpa->a_obid = NIL;
	  	newpa->a_letter = NULL;
		newpa->a_xspot = 0x0;
		newpa->a_yspot = 0x0;
	      }
	      pa = newpa;
	    }
	    else
	      fun_alert(1, ST_APGONE, NULLPTR);
	  }
						/* see if icon changed	*/
						/*   or flags changed	*/
	  if ( (uninstalled) ||
	       (oicon != nicon) ||
	       (oflag != nflag) )
	  {
	    change = TRUE;
	    pa->a_aicon = nicon + IA_GENERIC;
	    pa->a_dicon = nicon + ID_GENERIC;
	    pa->a_flags = nflag;
	  }
	}
	else if ( field == 1 )
	{
						/* remove installed app	*/
	  if ( !uninstalled )
	  {
	    app_free(pa);
	    change = TRUE;
	  }
	}

	return(change);
} /* ins_app */
