/*	DESKDIR.C	09/03/84 - 06/05/85	Lee Lorenzen		*/

/*
*	-------------------------------------------------------------
*	GEM Desktop					  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <taddr.h>
#include <deskdefn.h>
#include <dos.h>
#include <deskapp.h>
#include <deskfpd.h>
#include <deskwin.h>
#include <infodef.h>
#include <crysbind.h>
#include <deskbind.h>

EXTERN LONG		dos_alloc();
EXTERN LONG		dos_avail();
EXTERN WORD		dos_rename();
EXTERN WORD		dos_chdir();
EXTERN WORD		dos_chmod();
EXTERN WORD		dos_sdrv();
EXTERN WORD		dos_sfirst();
EXTERN WORD		DOS_AX;
EXTERN WORD		DOS_ERR;

EXTERN GLOBES		G;

MLOCAL BYTE		ml_files[4], ml_dirs[4];
MLOCAL WORD		ml_dlfi, ml_dlfo, ml_dlok, ml_dlcn;
MLOCAL WORD		ml_dlpr, ml_havebox;
MLOCAL BYTE		ml_fsrc[13], ml_fdst[13], ml_fstr[13], ml_ftmp[13];


/*
*	Routine to DRAW a DIALog box centered on the screen
*/

	VOID
draw_dial(tree)
	LONG		tree;
{
	WORD		xd, yd, wd, hd;

	form_center(tree, &xd, &yd, &wd, &hd);
	objc_draw(tree, ROOT, MAX_DEPTH, xd, yd, wd, hd);
} /* draw_dial */


do_namecon()
{
	if (ml_havebox)
	  draw_dial(G.a_trees[AD_CPALERT]);
	else
	{
	  show_box(G.a_trees[AD_CPALERT]);
	  ml_havebox = TRUE;
	}
	form_do(G.a_trees[AD_CPALERT], 0);
	if (ml_dlpr)
	  draw_dial(G.a_trees[AD_COPYDIAL]);
}

/*
*	Routine to HIDE a dialog BOX after it has been shown on the
*	screen
*/
	WORD
hide_box(tree)
	LONG		tree;
{
	WORD		xd, yd, wd, hd;

	form_center(tree, &xd, &yd, &wd, &hd);
	form_dial(FMD_FINISH, 0, 0, 0, 0, xd, yd, wd, hd);
} /* hide_box */


/*
*	Routine to SHOW a dialog BOX on the screen in preparation for
*	a form_do() call.
*/
	VOID
show_box(tree)
	LONG		tree;
{
	WORD		xd, yd, wd, hd;

	form_center(tree, &xd, &yd, &wd, &hd);
	form_dial(FMD_START, 0, 0, 0, 0, xd, yd, wd, hd);
	objc_draw(tree, ROOT, MAX_DEPTH, xd, yd, wd, hd);
} /* show_box */


/*
*	Draw a single field of a dialog box
*/
	VOID
draw_fld(tree, obj)
	LONG		tree;
	WORD		obj;
{
	GRECT		t;

	LWCOPY(ADDR(&t), OB_X(obj), 4);
	objc_offset(tree, obj, &t.g_x, &t.g_y);
	objc_draw(tree, obj, MAX_DEPTH, t.g_x, t.g_y, t.g_w, t.g_h);
} /* draw_fld */


	BYTE
*scan_slsh(path)
	BYTE		*path;
{
	WORD		ret;
						/* scan to first '*'	*/
	while (*path != '*')
	  path++;
						/* back up to last slash*/
	while (*path != '\\')
	  path--;
	return(path);
}


/*
*	Add a new directory name to the end of an existing path.  This
*	includes appending a \*.*.
*/
	VOID
add_path(path, new_name)
	BYTE		*path;
	BYTE		*new_name;
{
	while (*path != '*')
	  path++;
	strcpy(new_name, path);
	strcat("\\*.*", path);
} /* add_path */


/*
*	Remove the last directory in the path and replace it with
*	*.*.
*/
	VOID
sub_path(path)
	BYTE		*path;
{
						/* scan to last slash	*/
	path = scan_slsh(path);
						/* now skip to previous	*/
						/*   directroy in path	*/
	path--;
	while (*path != '\\')
	  path--;
						/* append a *.*		*/
	strcpy("\\*.*", path);
} /* sub_path */


/*
*	Add a file name to the end of an existing path.
*/
	VOID
add_fname(path, new_name)
	BYTE		*path;
	BYTE		*new_name;
{
	while (*path != '*')
	  path++;

	strcpy(new_name, path);
} /* add_fname */


/*
*	Routine to check to the name we will be adding is like the 
*	last folder name in the path.
*/
	VOID
like_parent(path, new_name)
	BYTE		*path;
	BYTE		*new_name;
{
	BYTE		*pstart, *lastfold, *lastslsh;
						/* remember start of path*/
	pstart = path;
						/* scan to lastslsh	*/
	lastslsh = path = scan_slsh(path);
						/* back up to next to 	*/
						/*   last slash if it 	*/
						/*   exists		*/
	path--;
	while ( (*path != '\\') &&
		(path > pstart) )
	  path--;
						/* remember start of 	*/
						/*   last folder name	*/
	if (*path == '\\')
	  lastfold = path + 1;
	else
	  lastfold = 0;

	if (lastfold)
	{
	  *lastslsh = NULL;
	  if( strcmp(lastfold, new_name) )
	    return;
	  *lastslsh = '\\';
	}
	add_fname(pstart, new_name);
} /* like_parent */


/*
*	See if these two paths represent the same folder.  The first
*	path ends in \*.*, the second path ends with just the folder.
*/
	WORD
same_fold(psrc, pdst)
	BYTE		*psrc;
	BYTE		*pdst;
{
	WORD		ret;
	BYTE		*lastslsh;
						/* scan to lastslsh	*/
	lastslsh = scan_slsh(psrc);
						/* null it		*/
	*lastslsh = NULL;
						/* see if they match	*/
	ret = strcmp(psrc, pdst);	
						/* restore it		*/
	*lastslsh = '\\';
						/* return if same	*/
	return( ret );
}



/*
*	Remove the file name from the end of a path and append on
*	an \*.*
*/

	VOID
del_fname(pstr)
	BYTE		*pstr;
{
	while (*pstr)
	  pstr++;
	while (*pstr != '\\')
	  pstr--;
	strcpy("\\*.*", pstr);
} /* sub_path */


/*
*	Parse to find the filename part of a path and return a copy of it
*	in a form ready to be placed in a dialog box.
*/
	VOID
get_fname(pstr, newstr)
	BYTE		*pstr, *newstr;
{
	while (*pstr)
	  pstr++;
	while(*pstr != '\\')
	  pstr--;
	pstr++;
	strcpy(pstr, &ml_ftmp[0]);
	fmt_str(&ml_ftmp[0], newstr);
} /* get_fname */


	WORD
d_errmsg()
{
	if (DOS_ERR)
	{
	  form_error(DOS_AX);
	  return(FALSE);
	}
	return(TRUE);
}


/*
*	Directory routine to DO File DELeting.
*/
	WORD
d_dofdel(ppath)
	BYTE		*ppath;
{ 
	dos_delete(ADDR(ppath));
	return( d_errmsg() );
} /* d_dofdel */


/*
*	Directory routine to DO File COPYing.
*/
	WORD
d_dofcopy(psrc_file, pdst_file, time, date, attr)
	BYTE		*psrc_file, *pdst_file;
	WORD		time, date, attr;
{
	WORD		srcfh, dstfh;
	UWORD		amntrd, amntwr;
	WORD		copy, cont, more, samedir;
		 
	copy = TRUE;
						/* open the source file	*/
	srcfh = dos_open(ADDR(psrc_file), 0);
	if (!(more = d_errmsg()) )
	  return(more);
	 					/* open the dest file	*/
	cont = TRUE;
	while (cont)
	{
	  copy = FALSE;
	  more = TRUE;
	  dstfh = dos_open(ADDR(pdst_file), 0);
					     	/* handle dos error	*/
	  if (DOS_ERR)
	  {
	    if (DOS_AX == E_FILENOTFND)
	      copy = TRUE;
	    else
	      more = d_errmsg();
	    cont = FALSE;
	  }
	  else
	  {
						/* dest file already	*/
						/*   exists		*/ 
	    dos_close(dstfh);
						/* get the filenames 	*/
						/*   from the pathnames	*/
	    get_fname(psrc_file, &ml_fsrc[0]);
						/* if same dir, then	*/
						/*   don't prefill the	*/
						/*   new name string	*/
	    if ( samedir = strcmp(psrc_file, pdst_file) )
	      ml_fdst[0] = NULL;
	    else
	      get_fname(pdst_file, &ml_fdst[0]);
						/* put in filenames	*/
						/*   in dialog		*/
	    inf_sset(G.a_trees[AD_CPALERT], 2, &ml_fsrc[0]);
	    inf_sset(G.a_trees[AD_CPALERT], 3, &ml_fdst[0]);
						/* show dialog		*/
	    do_namecon();
						/* if okay then if its	*/
						/*   the same name then	*/
						/*   overwrite else get	*/
						/*   new name and go	*/
						/*   around to check it	*/
	    copy = inf_what(G.a_trees[AD_CPALERT], CA_OK, CA_CNCL);
	    if (copy)
	    { 
	      inf_sget(G.a_trees[AD_CPALERT], 3, &ml_fdst[0]);
	      if ( strcmp(&ml_fsrc[0], &ml_fdst[0]) )
	      {
		copy = !samedir;
		cont = FALSE;
	      }
	      unfmt_str(&ml_fdst[0], &ml_fstr[0]);
	      if ( ml_fstr[0] == NULL )
		copy = cont = FALSE;
	      else
	      {
	        del_fname(pdst_file);
	        add_fname(pdst_file, &ml_fstr[0]);
	      }
	    }
	    else
	    {
	      dos_close(srcfh);
	      cont = copy = FALSE;
	    }
	  }
	} /* if found */

	if ( copy && more )
	  dstfh = dos_create(ADDR(pdst_file), attr);

	amntrd = copy;
	while( amntrd && more )
	{
	  if ( more = d_errmsg())
	  {
	    amntrd = dos_read(srcfh, G.g_xlen, G.g_xbuf);
	    if ( more = d_errmsg() )
	    {
	      if (amntrd)
	      {
	        amntwr = dos_write(dstfh, amntrd, G.g_xbuf);
	        if ( more = d_errmsg() )
	        {
	          if (amntrd != amntwr)
	          {
						/* disk full		*/
		    fun_alert(1, ST_DISKFULL, NULLPTR);
	            more = FALSE;
		    dos_close(srcfh);
		    dos_close(dstfh);
		  }
	        }
	      }
	    }
	  }
	}
	if (copy && more)
	{
	  dos_setdt(dstfh, time, date);
	  more = d_errmsg();
	  dos_close(srcfh);
	  dos_close(dstfh);
	}
	return(more);
} /* d_dofcopy */


/*
*	Directory routine to DO an operation on an entire sub-directory.
*/
	WORD
d_doop(op, tree, psrc_path, pdst_path, pfcnt, pdcnt)
	WORD		op;
	LONG		tree;
	BYTE		*psrc_path, *pdst_path;
	WORD		*pfcnt, *pdcnt;
{			       
	BYTE		*ptmp;
	WORD		cont, skip, more, level;
						/* start recursion at	*/
						/*   level 0		*/
	level = 0;
						/* set up initial DTA	*/
	dos_sdta(ADDR(&G.g_fcbstk[level]));
	dos_sfirst(ADDR(psrc_path), 0x16);

	cont = more = TRUE;
	while (cont && more)
	{
	  skip = FALSE;
	  if (DOS_ERR)
	  {
				  		/* no more files error	*/
	    if ( (DOS_AX == E_NOFILES) ||
		 (DOS_AX == E_FILENOTFND) )
	    {
	      switch(op)
	      {
	        case OP_COUNT:
			G.g_ndirs++;
			break;
	        case OP_DELETE:
			ptmp = psrc_path;
			while(*ptmp != '*')
			  *ptmp++;
			ptmp--;
			*ptmp = NULL;
			dos_rmdir(ADDR(psrc_path));
			more = d_errmsg();
			strcat("\\*.*", psrc_path);
			break;
	        case OP_COPY:
			break;
	      }
	      if (tree)
	      {
	        *pdcnt -= 1;
	        merge_str(&ml_dirs[0], "%W", pdcnt);
	        inf_sset(tree, ml_dlfo, &ml_dirs[0]);
	        draw_fld(tree, ml_dlfo);
	      }
	      skip = TRUE;
	      level--;
	      if (level < 0)
	        cont = FALSE;
	      else
	      {
	        sub_path(psrc_path);
		if (op == OP_COPY)
		  sub_path(pdst_path);
	        dos_sdta(ADDR(&G.g_fcbstk[level]));
	      }
	    } /* if no more files */
	    else
	      more = d_errmsg();
	  }
	  if ( !skip && more )
	  {
	    if ( G.g_fcbstk[level].fcb_attr & F_SUBDIR )
	    {				  	/* step down 1 level	*/
	      if ( (G.g_fcbstk[level].fcb_name[0] != '.') &&
		   (level < (MAX_LEVEL-1)) )
	      {
	      					/* change path name	*/
		add_path(psrc_path, &G.g_fcbstk[level].fcb_name[0]);
		if (op == OP_COPY)
		{
		  add_fname(pdst_path, &G.g_fcbstk[level].fcb_name[0]);
		  dos_mkdir(ADDR(pdst_path));
	          if ( (DOS_ERR) && 
		       (DOS_AX != E_NOACCESS) )
		    more = d_errmsg();
		  strcat("\\*.*", pdst_path);
		}
		level++;
		dos_sdta(ADDR(&G.g_fcbstk[level]));
		if (more)
		  dos_sfirst(ADDR(psrc_path), 0x16);
	      } /* if not a dir */
	    } /* if */
	    else				 
	    {
	      if (op)
		add_fname(psrc_path, &G.g_fcbstk[level].fcb_name[0]);
	      switch(op)
	      {
		case OP_COUNT:
			G.g_nfiles++;
			G.g_size += G.g_fcbstk[level].fcb_size;
			break;
		case OP_DELETE:
			more = d_dofdel(psrc_path);
			break;
		case OP_COPY:
			add_fname(pdst_path, &G.g_fcbstk[level].fcb_name[0]);
			more = d_dofcopy(psrc_path, pdst_path,
				G.g_fcbstk[level].fcb_time, 
				G.g_fcbstk[level].fcb_date, 
				G.g_fcbstk[level].fcb_attr);
			del_fname(pdst_path);
			break;
	      }
	      if (op)
	        del_fname(psrc_path);
	      if (tree)
	      {
	        *pfcnt -= 1;
		merge_str(&ml_files[0], "%W", pfcnt);
	        inf_sset(tree, ml_dlfi, &ml_files[0]);
	        draw_fld(tree, ml_dlfi);
	      }
	    }
	  }
	  if (cont)
	    dos_snext();
	}

	return(more);
} /* d_doop */


/*
*	DIRectory routine that does an OPeration on all the selected files and
*	folders in the source path.  The selected files and folders are 
*	marked in the source file list.
*/
	WORD
dir_op(op, psrc_path, pflist, pdst_path, pfcnt, pdcnt, psize)
	WORD		op;
	BYTE		*psrc_path;
	FNODE		*pflist;
	BYTE		*pdst_path;
	WORD		*pfcnt, *pdcnt;
	LONG		*psize;
{
	LONG		tree;
	LONG		lavail;
	FNODE		*pf, *ptmpf;
	REG UWORD	ii;
	WORD		ret, more;
	BYTE		*pname, *pstr, *pglsrc, *pgldst;

	pglsrc = &G.g_srcpth[0];
	pgldst = &G.g_dstpth[0];
	tree = 0x0L;
	ml_havebox = FALSE;
	switch(op)
	{
	  case OP_COUNT:
		G.g_nfiles = 0x0L;
		G.g_ndirs = 0x0L;
		G.g_size = 0x0L;
	 	break;
	  case OP_DELETE:
		if (ml_dlpr = G.g_cdelepref)
		{
		  tree = G.a_trees[AD_DELEDIAL];
		  ml_dlfi = DD_FILES;
		  ml_dlfo = DD_FOLDS;
		  ml_dlok = DD_OK;
		  ml_dlcn = DD_CNCL;
		}
	 	break;
	  case OP_COPY:
		lavail = dos_avail();
		G.g_xlen = (lavail > 0x0000fff0L) ? 0xfff0 : LLOWD(lavail);
		G.g_xlen -= 0x0200;
		G.g_xbuf = dos_alloc( LW(G.g_xlen) );

		if (ml_dlpr = G.g_ccopypref)
		{
		  tree = G.a_trees[AD_COPYDIAL];
						/* get xfer buff, try	*/
						/* 1/2 less each time	*/
	 	  ml_dlfi = CD_FILES;
		  ml_dlfo = CD_FOLDS;
		  ml_dlok = CD_OK;
		  ml_dlcn = CD_CNCL;
		}
	 	break;
	}

	if (tree)
	{
	  merge_str(&ml_files[0], "%W", pfcnt);
	  inf_sset(tree, ml_dlfi, &ml_files[0]);
	  merge_str(&ml_dirs[0], "%W", pdcnt);
	  inf_sset(tree, ml_dlfo, &ml_dirs[0]);
	  ml_havebox = TRUE;
	  show_box(tree);
	  form_do(tree, 0);
	  ret = inf_what(tree, ml_dlok, ml_dlcn);
	}
	else
	  ret = TRUE;

	if (ret)
	{
	  pf = pflist;
	  more = TRUE;
	  while (pf && more)
	  {
	    ptmpf = pf->f_next;
	    if (pf->f_obid != NIL)
	    {
	      if (G.g_screen[pf->f_obid].ob_state & SELECTED)	       
	      {
		strcpy(psrc_path, pglsrc);
		if (op == OP_COPY)
		  strcpy(pdst_path, pgldst);
		if (pf->f_attr == F_SUBDIR)
		{			   
		  add_path(pglsrc, &pf->f_name[0]);
		  switch(op)
		  {
		    case OP_COPY:
			like_parent(pgldst, &pf->f_name[0]);
			dos_mkdir(ADDR(pgldst));
			while (DOS_ERR && more)
			{
						/* see if dest folder	*/
						/*   already exists	*/ 
	    		  if (DOS_AX == E_NOACCESS)
			  {
			    if ( same_fold(pglsrc, pgldst) )
			    {
						/* get the folder name 	*/
						/*   from the pathnames	*/
			      fmt_str(&pf->f_name[0], &ml_fsrc[0]);
			      ml_fdst[0] = NULL;
						/* put in folder name	*/
						/*   in dialog		*/
			      inf_sset(G.a_trees[AD_CPALERT], 2, &ml_fsrc[0]);
			      inf_sset(G.a_trees[AD_CPALERT], 3, &ml_fdst[0]);
						/* show dialog		*/
			      do_namecon();
						/* if okay then make	*/
						/*   dir or try again	*/
						/*   until we succeed or*/
						/*   cancel is hit	*/
			      more = inf_what(G.a_trees[AD_CPALERT], 
					CA_OK, CA_CNCL);
			      if (more)
			      { 
			        inf_sget(G.a_trees[AD_CPALERT], 3, 
						&ml_fdst[0]);
			        unfmt_str(&ml_fdst[0], &ml_fstr[0]);
			        del_fname(pgldst);
			        if (ml_fstr[0] != NULL)
			        {
			          add_fname(pgldst, &ml_fstr[0]);
			          dos_mkdir(ADDR(pgldst));
		 	        }
			        else
				  more = FALSE;
			      }
			    }
			    else
			      DOS_ERR = FALSE;
			  }
			  else
			    more = FALSE;
			}
			strcat("\\*.*", pgldst);
			break;
		  }
		  if (more)
		    more = d_doop(op, tree, pglsrc, pgldst,
				 pfcnt,	pdcnt);
		}
	        else
	        {
		  if (op)
		    add_fname(pglsrc, &pf->f_name[0]);
		  switch(op)
		  {
		    case OP_COUNT:
			G.g_nfiles++;
			G.g_size += pf->f_size;
			break;
		    case OP_DELETE:
			more = d_dofdel(pglsrc);
			break;
		    case OP_COPY:
			add_fname(pgldst, &pf->f_name[0]);
			more = d_dofcopy(pglsrc, pgldst,
			           pf->f_time, pf->f_date, pf->f_attr);
			del_fname(pgldst);
			break;
		  }
		  if (op)
		    del_fname(psrc_path);
		  if (tree)
		  {
		    *pfcnt -= 1;
		    merge_str(&ml_files[0], "%W", pfcnt);
		    inf_sset(tree, ml_dlfi, &ml_files[0]);
		    draw_fld(tree, ml_dlfi);
		  }
		}
	      }
	    }
	    pf = ptmpf;
	  }
	}

	switch(op)
	{
	  case OP_COUNT:
		*pfcnt = G.g_nfiles;
		*pdcnt = G.g_ndirs;
		*psize = G.g_size;
	 	break;
	  case OP_DELETE:
	 	break;
	  case OP_COPY:
		dos_free(G.g_xbuf);
	 	break;
	}
	if (ml_havebox)
	  hide_box(G.a_trees[AD_CPALERT]);

	return(TRUE);
} /* dir_op */
