/***************************************************************************
 *									    
 *			  t c l o s e   F u n c t i o n			    
 *			  -----------------------------			    
 *	Copyright 1983 by Digital Research Inc.  All rights reserved.	    
 *									    
 *	The tclose function is used to terminate access to a file / device, 
 *	then to truncate (the file) at the current file position.	    
 *									    
 *	Calling Sequence:						    
 *		ret = tclose(fd);					    
 *									    
 *	Where:								    
 *		fd == an open file descriptor to be TCLOSEd		    
 *		ret == 0 if ok, -1 if failure (not supported by O.S., etc.) 
 *									    
 *	REV:
 *		2/85 JC	Replaced conditional compiled expressions
 *		3/85 JC changed call to close4 to close
 ****************************************************************************/

#include "portab.h"
#include "osattr.h"
#include "osif.h"
#include "osiferr.h"
#include "errno.h"
						/****************************/
EXTERN	BYTE	__xeof;				/* End of file for ASCII    */
						/****************************/
WORD	tclose(fd)				/* CLEAR FUNCTION	    */
REG	WORD	fd;				/* File descriptor to close */
{						/*			    */
EXTERN	FD	*_chkc();			/* fd -> fp conversion	MGL */
REG	FD	*fp;				/* file pointer Temporary   */
REG	WORD	rv;				/* return value		    */
	WORD	xuser;				/* User number temporary    */
	WORD 	TruncIt;			/* Flag: call F_TRUNC func  */
	LONG	SaveSector;			/* Sector ptr for TruncIt   */
						/*			    */
	if( os_truncates )			/* Does O.S. support this?  */
		{rv = SUCCESS; TruncIt = TRUE;}	/* Yes, assume all will be ok*/
	else	{rv = FAILURE; TruncIt =FALSE;}	/* No: close anyway	    */
#if CPM /********************************************************************/
	if((fp=_chkc(fd)) == NULLFD)		/* File Open?		    */
	    RETERR(FAILURE,EBADF);		/*		no, quit    */
	if ((fp->flags & (ISTTY|ISLPT)) == 0)	/* Character device?	    */
	{					/* if not, handle file: *****/
	  SaveSector = (fp->offset+127) >> 7;	/* Needed by TruncIt	    */
	  if( fp->flags & ISASCII )		/* EOF needs mark?	    */
	    write(fd,&__xeof,1);		/* Write a ^Z character	    */
	  if((fp->flags & DIRTY) != 0)		/* Buffer dirty?	    */
	    if(_blkio(fp,fp->sector,fp->buffer,1L,B_WRITE) != 1)/* write it */
	      rv = FAILURE;			/* can't		    */
	  xuser = _chkuser(fp->user);		/* Check user # for change  */
	  if(__OSIF(CLOSE,&(fp->fcb)) == 0xFF)	/* Close the fcb	    */
	    rv = FAILURE;			/*			    */
	  if( TruncIt ) {			/* Truncating the file?	    */
#if HILO					/*--------------------------*/
	    fp->fcb.record = SaveSector;	/* For F_TRUNC		    */
#else						/*--------------------------*/
	    fp->fcb.record = SaveSector << 8;	/* For F_TRUNC		    */
#endif						/*--------------------------*/
	    if(__OSIF(F_TRUNC,&(fp->fcb)))	/* Non zero if fails	    */
	      rv = FAILURE;			/*			    */
	  }					/***			    */
	  _uchkuser(fp->user,xuser);		/* Change user # if needed  */
	}					/* end of file handling	*****/
	__chinit(fd);				/* Release the space	    */
	_freec(fd);				/* Release the channel	    */
	if( rv == SUCCESS )			/* Was everything ok?	    */
	     return(rv);			/* Yes, return Success	    */
	else RETERR(FAILURE,EIO);		/* else let them know 	    */
#endif
#if PC1OR2
	return(close(fd));
#endif
}						/****************************/

                                                            