/* Additional string functions not included in strfns.c
*
*  There are assembler versions (8086) of the routines in strfns.c,
*  there are no assembler versions of the routines contained in this file.
*
*  strcspn
*  strpbrk
*  strspn
*  strtok
*
*/

/* strcspn - find length of initial segment of s1 that consists
**	     entirely of characters not from s2
**
** calling sequence:
**	len = strcspn(s1, s2)
**
** return:
**	len = # of characters from the initial segment of s1 that
**	      consists entirely of characters not from s2
**
*/

int
strcspn(s1, s2)
char	*s1, *s2;
{
	register char	*ts1;
	register char	*ts2;

	/* step through s1 
	** when a char from s2 matches one from s1, compute len and return
	*/
	for(ts1 = s1; *ts1; ts1++)
	{
		for(ts2 = s2; *ts2; ts2++)
			if(*ts1 == *ts2)
				break;
		if(*ts2)
			break;
	}
	return(ts1-s1);
}
 
/* strpbrk - look for characters from s2 in s1
**
** calling sequence:
**	ptr = strpbrk(s1, s2)
**
** return:
**	ptr = pointer to the first occurrence in s1 of any character
**	      from s2.  ptr is NULL if no character from s2 exists in s1.
**
*/

char	*
strpbrk(s1, s2)
char	*s1, *s2;
{
	register	char	*ts1;	/* temp s1 */
	register	char	*ts2;	/* temp s2 */

	/* compare each character in s1 to all characters in s2 */
	/* if match is found return pointer to position in s1 */
	for(ts1 = s1; *ts1; ts1++)
		for(ts2 = s2; *ts2; ts2++)
			if(*ts2 == *ts1)
				return(ts1);

	return(0);
}

/* strspn - find length of initial segment of s1 that consists
**	    entirely of characters from s2
**
** calling sequence:
**	len = strspn(s1, s2)
**
** return:
**	len = # of characters from the initial segment of s1 that
**	      consists entirely of characters from s2
**
*/

int
strspn(s1, s2)
char	*s1, *s2;
{
	register	char	*ts1;
	register	char	*ts2;

	/* step through s1 
	** if a char from s2 matches, move on to next s1 char 
	** if at the end of s2, no char matches. get out of loop
	** and compute length of initial segment 
	*/
	for(ts1 = s1; *ts1; ts1++)
	{
		for(ts2 = s2; *ts2; ts2++)
			if(*ts1 == *ts2)
				break;
		if(!*ts2)
			break;
	}
	return(ts1 - s1);
}

/* strtok - find tokens in string
**	    s1 is a string of 0 or more tokens
**	    s2 is a string of 1 or more separator tokens
**	    when a token is found, a null is written immediately
**	    after it.  strtok keeps track of its position in the
**	    string between calls so that subsequent calls (with s1=NULL)
**	    will work through s1 following that token.  when no tokens
**	    remain, a null pointer is returned.
**
** calling sequence:
**	ptr = strtok(s1, s2)
**	ptr = strtok(NULLPTR, s2)
**
** return:
**	pointer to token or NULLPTR
*/

char	*
strtok(s1, s2)
char	*s1, *s2;
{
	static		char	*pos;		/* position in string */
	register	char	*starttok;	/* ptr to start of token */

	if(s1 != (char *) 0)
		pos = s1;	/* initialize */

	pos += strspn(pos,s2);		/* find where token starts */
	starttok = pos;
	if(*pos == 0)			/* no more tokens */
		return(0);
	pos += strcspn(pos,s2);		/* find where token ends */
	if(*pos)
		*pos++ = 0;		/* put null in s1 at end of token */

	return(starttok);
}
 
                                                         