
/*
*	NAME:	_rdasc
*
*	FUNCTION:
*		The "_rdasc" function performs a read operation for ascii  files.
*		All Return chars (0x13) are eliminated (and not counted) from input.
*
*	USAGE:
*		int  _rdasc(fp,buffer,bytes)
*
*	ARGUMENTS:
*		FD  *	fp	-> to the open CCB
*		char * buffer	-> the user's buffer
*		unsigned  bytes	=  the number of bytes to be read
*
*	RETURN:
*		number of bytes actually read
*
*	REVISION HISTORY:
*		Edits:
*		20-jan-84   whf Handle PCDOS ^Z bug
*		11-april-84 as	Modified for PCDOS 2.0
*		April-84 Changed to call _rdbin for all OS   (AS)
*		2/85	JC	replaced conditional compiled expressions
*
*/


#include "portab.h"
#include "osif.h"
#include "osiferr.h"
#include "errno.h"

int
_rdasc(fp,buff,bytes)			/****************************/
REG	FD	*fp;			/* -> ccb for the file	    */
REG	char	*buff;			/* -> buffer to receive data*/
REG	unsigned int	bytes;		/* =  # bytes to xfer	    */
{					/****************************/

	unsigned int	xbytes; 		/* byte count save	    */
	UWORD	ii, jj; 			/* More byte count temps    */
	UWORD	_cr_collapse(); 		/* Zaps CRs in buff	    */


    xbytes = bytes;				/* Remember org. request    */
    while(bytes > 0  &&  (fp->flags&ATEOF)==0 ) /* Until read is satisfied  */
    {						/****************************/

	ii = _rdbin(fp, buff, bytes);		/* Rdbin does the actual rd */
	for( jj=0; jj<ii; ++jj )		/* EOF scan		    */
	    if (buff[jj] != EOFCHAR ) break;	/* Last char EOF ?	    */
	if( ii==0  ||  buff[jj] == EOFCHAR ){	/* No chars or Last char EOF?*/
		fp->flags |= ATEOF;		/* Yes, mark file	    */
		ii = jj;		      /* Num valid chars	  */
	}					/*			    */
	jj = _cr_collapse(buff,ii);		/* Stomp out 0x13	    */
	buff += jj;				/* advance the buffer ptr   */
	bytes -=jj;				/* discount by bytes in buff*/
    }						/* While bytes > 0	    */
    xbytes -= bytes;				/* Number really read	    */
    return(xbytes);				/* Read fully satisfied     */
}						/****************************/



/*
* _cr_collapse: Gets rid of "\r" (0x13)
* from the buffer.
*
*/

					       /*****************************/
UWORD _cr_collapse(buf,cnt)		       /* Stomp out Returns (0x13)  */
REG BYTE *buf;				       /* Where to stomp	    */
    UWORD cnt;				       /* How much of buf to stomp  */
{					       /*			    */
REG   BYTE *chk;			       /* Check pointer 	    */
      BYTE *savbuf;			       /* Save pointer		    */
      BYTE *endbuf;			       /* Move to pointer	    */
					       /*			    */
      savbuf = buf;			       /* save for return val	    */
      endbuf = buf + cnt;		       /* after last char in buf    */
      for( chk = buf; chk < endbuf; chk++)     /* Check out entire buffer   */
	 if( *chk != '\r' )                    /* If not a RETURN           */
	    *buf++ = *chk;		       /*     move it down	    */
      return( buf -savbuf);		       /* New num chars in buf	    */
}



#if PC1OR2
/*
*  _rdlin: reads one line at a time from the
*  consol and (0x13) is stomped out.
*
*/

UWORD  _rdlin(fp,buf,bytes)
FD   *fp;
BYTE *buf;
UWORD bytes;
{
   UWORD ii;

      ii = _rdbin(fp,buf,bytes);
      return(_cr_collapse(buf,ii));

}
#endif
                                                                                                