
/*
 *	NAME: lseek
 *
 *	FUNCTION:
 *		The lseek function changes the present position of reading
 *		to or writing from a file.
 *		The tell function returns the present position in a file.
 *
 *	USAGE:
 *		long lseek(fd,offset,sense)
 *		long tell(fd)
 *
 *	ARGUMENTS:
 *	  int	fd	Is an open file descriptor
 *	  long	offset	Is the (long) file offset
 *	  int	sense	Is the meaning of offset
 *			0 => From the beginning of the file
 *			1 => From the present file position
 *			2 => From the end of the file
 *
 *	RETURNS:	The resulting absolute file offset
 *			-1 indicates failure
 *
 *	REVISION HISTORY:
 *		Changed pcdos2 lseek 3/85 JC
 *		Replaced conditional compiled expressions 2/85 JC
 *		Split into separate files for pcdosb 12/84 JC
 *		  Modified to wrok on PCDOS 2.0  AS april-11-84
 *		  dynamic checking for pcdos versions	 AS APRIL,84
*/

#include "portab.h"
#include "osif.h"
#if CPMXPC1

long
lseek(fd,offs,sense)			/* CLEAR FUNCTION ***********/
int	fd;				/* Open file descriptor     */
long	offs;				/* File offset		    */
int	sense;				/* Sense of offset	    */
					/****************************/
{
	long	_lseek1();

	return(_lseek1(fd, offs, sense));
}

long
tell(fd)
int	fd;
{
	long	_lseek1();

	return(_lseek1(fd, 0L, 1));
}
#endif

#if PC2ONLY
long
lseek(fd,offs,sense)			/* CLEAR FUNCTION ***********/
int	fd;				/* Open file descriptor     */
long	offs;				/* File offset		    */
int	sense;				/* Sense of offset	    */
					/****************************/
{
	long	_lseekx();

	return(_lseekx(fd,offs,sense));
}

long
tell(fd)
int	fd;
{

	long	_lseekx();

	return(_lseekx(fd, 0L, 1));
}						/****************************/


#endif

#if PCBOTH
#include "osattr.h"
long
lseek(fd,offs,sense)			/* CLEAR FUNCTION ***********/
int	fd;				/* Open file descriptor     */
long	offs;				/* File offset		    */
int	sense;				/* Sense of offset	    */
					/****************************/
{
	long	_lseek1(), _lseekx();

	if(os_unixlike)
		return(_lseekx(fd, offs, sense));
	else
		return(_lseek1(fd, offs, sense));
}
long
tell(fd)
int	fd;
{
	long	_lseek1(), _lseekx();

	if (os_unixlike)
		return(_lseekx(fd, 0L, 1));
	else
		return(_lseek1(fd, 0L, 1));
}

#endif

#if PCDOS2

/*
* _adj_eofptr:	This routine checks to see
* whether the last char in the file is ctrl-z
* or not.  If the last char is ctrl-z then seek
* to -1 from the end of file to get rid of ctrl-z.
* else return the saved offset.
*/

long _adj_eofptr(fp,offset)
FD *fp;
long offset;
{
  BYTE buf[1];
  WORD i;

  if ( fp->flags & ISASCII ) {			 /* donot adjust for binary  */
   if ( dos2lseek((int)fp->fd, -1L, 1) != FAILURE) { /* Seek to -1 to read the   */
	 i = read(fp,buf,1);			 /* last character.	     */
	 if((i == 1) &&( *buf == EOFCHAR ))	 /* Read successfully ctrl-z */
	    return(dos2lseek((int)fp->fd,-1L,1));  /* return saved offset - 1  */
	 else { 				 /* No ctrl-z or read error  */
		if ( i < 1 )			 /* Nothing was read, so     */
		  dos2lseek((int)fp->fd,1L,1);     /* bump the rd/wt pointer   */
		 return(offset);		 /* return the saved offset  */
	 }					 /*			     */
   } else return(offset);			 /* something was wrong,     */
 }
 else return(offset);				 /* It was binary	     */
}						 /* return the saved offset  */

#include	"osiferr.h"
#include	"errno.h"
long
_lseekx(fd, offs, sense)
int	fd;
long	offs;
int	sense;
{
						/****************************/
	REG	FD	*fp;			/* File pointer 	    */
	EXTERN	FD	*_chkc();		/* fd to fp translation MGL */
	long		offset;

	if((fp = _chkc(fd)) == NULLFD)		/* Convert to pointer	    */
		RETERR(FAILURE,EBADF);		/*   Can't                  */
						/*			    */
	if ((offset = dos2lseek(fp->fd, offs, sense)) == FAILURE)/*	    */
	     return(FAILURE);			/*     return -1	    */
	else
	{
		fp->flags &= ~ATEOF;		/* Any seek clears EOF Flag */
	       if ((sense == 2) && (offs == 0L))/* Was the seek to EOF?     */
		  return(_adj_eofptr(fp,offset));/* yes, clear ctrl-Z, if any*/
	       else return(offset);		/*			    */
	}					/*			    */
}						/****************************/
#endif

     