
/*
 *	NAME:	close
 *
 *	FUNCTION:
 *		The close function is used to terminate access to a file/device.
 *
 *	USAGE:
 *		int   close(fd)
 *
 *	ARGUMENTS:
 *		int	fd	open file descriptor to be CLOSEd.
 *
 *	RETURNS: return FAILURE (-1) if unsuccessful, SUCCESS (0) o.w.
 *
 *	REVISION HISTORY:
 *		Modifications:
 *		3/85   changes for dos2close JC
 *		2/85   replaced conditional compile expressions
 *		1/85   Standards changes JC
 *		12/84  Split into separate files for pcdosb JC
 *		4/84 : Dynamic check for PC-DOS versions
 *		3/84 : PC-DOS V2.0   as
 *		12/83: PC-DOS mods   whf
 *		10/83: changed user # handling	 whf
 *		9/83: add steve's user # mods, change _chkc   whf
 *		8/83: improve error handling	whf
*/

#include "portab.h"
#include "osif.h"
#include "osiferr.h"
#include "errno.h"

#if CPM
EXTERN	BYTE	__xeof; 			/* End of file for ASCII    */

int
close(fd)				/* CLEAR FUNCTION ***********/
register	int	fd;		/* File descriptor to close */
{					/****************************/

EXTERN	FD	*_chkc();			/* fd -> fp conversion	MGL */
REG	FD	*fp;				/* file pointer Temporary   */
REG	WORD	rv;				/* return value 	    */
REG	WORD	xuser;				/* User number temporary    */
						/*			    */
	rv = SUCCESS;
	if((fp=_chkc(fd)) == NULLFD)		/* File Open?		    */
	    RETERR(FAILURE,EBADF);		/*		no, quit    */
	if ((fp->flags & (ISTTY|ISLPT)) == 0) { /* Character device?	    */

	  if((fp->flags & ISASCII) != 0 && (fp->flags & ISREAD) == 0)	/*  */
	  {					/* ASCII file? not ReadOnly?*/
	    if( fp->offset < fp->hiwater )	/* Have we been seeking?    */
	      lseek(fd,0L,2);			/*   Seek to EOF ifso	    */
	    write(fd,&__xeof,1);		/* Write a ^Z character     */
	  }					/****************************/
	  if((fp->flags & DIRTY) != 0)		/* Buffer dirty?	    */
	    if(_blkio(fp,fp->sector,fp->buffer,1L,B_WRITE) != 1)/* write it */
	      rv = FAILURE;			/* can't                    */
	  xuser = _chkuser(fp->user);		/* Check user # for change  */
	  if((__OSIF(CLOSE,&(fp->fcb))&0xFF) == 0xFF)/* Close the fcb	    */
	    rv = FAILURE;			/*			    */
	  _uchkuser(fp->user,xuser);		/* Change user # if needed  */

	}					/* end of file handling *****/
	__chinit(fd);				/* Release the space	    */
	_freec(fd);				/* Release the channel	    */
	if( rv == SUCCESS )			/* Was everything ok?	    */
	     return(rv);			/* Yes, return Success	    */
	else RETERR(FAILURE,EIO);		/* else let them know	    */
}						/****************************/
#endif

#if PC1ONLY

int
close(fd)				/* CLEAR FUNCTION ***********/
register	int	fd;		/* file desc to close */
{					/****************************/
	return(_close3(fd));
}
#endif

#if PC2ONLY

int
close(fd)				/* CLEAR FUNCTION ***********/
register int	fd;			/* File descriptor to close */
{					/****************************/
EXTERN	FD	*_chkc();			/* fd -> fp conversion	MGL */
REG	FD	*fp;				/* file pointer Temporary   */
REG	WORD	rv;				/* return value 	    */

	rv = SUCCESS;				/*			    */
	if((fp=_chkc(fd)) == NULLFD)		/* File Open?		    */
	    RETERR(FAILURE,EBADF);		/*		no, quit    */
	if ((fp->flags & (ISTTY|ISLPT)) == 0) { /* Character device?	    */
		rv = dos2close(fd);
	}					/* end of file handling *****/
	__chinit(fd);				/* Release the space	    */
	_freec(fd);				/* Release the channel	    */
	if( rv != SUCCESS )			/* Was everything ok?	    */
		RETERR(FAILURE,EIO);		/* no, let them know	    */
	return(rv);				/* success 		    */
}						/****************************/
#endif

#if PCBOTH
#include	"osattr.h"

int
close(fd)				/* CLEAR FUNCTION ***********/
register int	fd;			/* File descriptor to close */
{					/****************************/

EXTERN	FD	*_chkc();			/* fd -> fp conversion	MGL */
REG	FD	*fp;				/* file pointer Temporary   */
REG	WORD	rv;				/* return value 	    */

	if(os_unixlike)
	{
		rv = SUCCESS;			/*			    */
		if((fp=_chkc(fd)) == NULLFD)	/* File Open?		    */
			RETERR(FAILURE,EBADF);	/*		no, quit    */
		if ((fp->flags & (ISTTY|ISLPT)) == 0)/* Character device?   */
			rv = dos2close(fd);
		__chinit(fd);			/* Release the space	    */
		_freec(fd);			/* Release the channel	    */
		if( rv != SUCCESS )		/* Was everything ok?	    */
			RETERR(FAILURE,EIO);	/* no, let them know	    */
		return(rv);
	}
	else
		return(_close3(fd));
}
#endif
                                                                                     