;p720k.asm : read/write 720K-disks in drives for the AT
;
;TSR for drive A and B
;

code segment
	assume cs:code
	org     100h
start:
	jmp     init

newint13:
	cli			;disable interrupts
	cmp     ah, 0        	;disk reset ?
	jne     @@_next        	;no
	mov     cs:reset, 1  	;yes: set reset flag
	jmp     @@_continue
@@_next:
	mov     cs:reset, 0  	;clear reset flag
@@_continue:
	cmp     ah, 3        	;Sektoren schreiben
	jg      oldint13     	;greater -> old int 13h
	cmp     ah, 2        	;Sektoren lesen
	jb      oldint13     	;below -> old int 13h
	cmp     dl, 1        	;>1 (not drive A=0, B=1 ?)
	jg     oldint13      	;no
	mov cs:drive,dl		;save drive
	cmp     ch, 0   	;track 0 ?
	je      oldint13     	;yes
	sti                  	;enable interrupts
	pushf
	call    dword ptr cs:[int13]	;old int13
	jnc     @@_ready         	;ok, no error
	cmp     ah, 4        	;sector not found ?
	jne     @@_cont1      	;no
	dec     cs:errcount	;dec error-counter
	cmp     cs:errcount, 0	;more retries ?
	jne     @@_cont1       	;no
	mov     cs:errcount, 2 	;init error-counter
	cmp     cs:sstep, 1	;already single-step ?
	je      @@_switch     	;yes
	mov     cs:sstep, 1 	;set single step flag
	call    step          	;set also in BIOS
	jmp     @@_cont1
@@_switch:
	mov     cs:sstep, 0 	;set double step
@@_cont1:
	stc                  	;set carry for error
	jmp     @@_ready

oldint13:
	sti	                ;reenable interrupts
	pushf
	call    dword ptr cs:[int13] ;call old int 13h
	pushf
	cmp     dl, cs:drive  	;only disk-access to selected drive?
	jne     @@_finish       ;no disk access
	cmp     cs:reset, 1   	;reset flag set ?
	jne     @@_finish       ;no
	cmp     cs:sstep, 1 	;single step ?
	jne     @@_finish       ;no
	call    step          	;set single step
@@_finish:
	popf
@@_ready:
	push    ax
	pushf
	pop     ax           	;get flags to ax
	push    bp
	mov     bp, sp
	mov     ss:[bp+8], ax
	;update flag register
	pop     bp
	pop     ax
	iret

step proc near
	push    ax
	push    ds
	mov     ax, 0040h
	mov     ds, ax		;segment register
	;switch to single step in BIOS
	cmp cs:drive,0		;drive 0?
	jne @@_step1		;no
	and byte ptr ds:[0090h], 11011111b	;for drive A
	jmp @@_step2
@@_step1:
	and byte ptr ds:[0091h], 11011111b	;or for drive B
@@_step2:
	pop     ds
	pop     ax
	ret
step endp

int13		dd 	?	;old vector
errcount        db 	?       ;error-counter
sstep	        db 	?       ;single step flag
reset           db 	?       ;reset flag
drive 		db 	?	;drive number during int 13


init:
	mov     errcount, 2   	;init retry count
	mov     sstep, 0   	;no single step
	mov     reset, 0	;no reset
	mov     ah, 35h 	;get old int 13h vector ...
	mov     al, 13h
	int     21h
	mov     word ptr int13, bx	;offset
	mov     word ptr int13+2, es	;segment
	mov     dx, offset newint13 	;new int 13h vector
	mov     ah, 25h		;set
	mov     al, 13h
	int     21h
	mov     dx, offset output
	mov     ah, 9
	int     21h		;output string
	mov     ax, 3100h
	mov     dx, ((offset init-offset start)+10fh) shr 4
	int     21h          	;end program resident

output db 13,10,'5,25-720K TSR for AT ready.',13,10,'$'

code ends
end start
