	page	,132
	title	IOM_Skeleton - I/O Map Skeleton

	.model	small,c
	.code
	assume	cs:@Code,ds:@Code,es:@Code,ss:nothing

; --------------------------------------------------------------------
;	Note that this program is assumed to be loaded at 0000 in the
;	current segment.
;
;	This overlay can be compiled with -
;
;		ML /Fe ioskel.iom ioskel.asm /link /T
;
;	An IOMAP overlay must begin with the following header:
; ---------------------------------------------------------------------


IOMAP_MAX_SIZE	equ	32767		; size of largest I/O map processor
IOMAP_SIGNATURE equ	'MI'		; IO Map signature

;	Layout of an IOMap comm block.

IOMAPB		struc
iom_ident	dw	?		; identifier of IOM
iom_init	dw	?		; offset of initialization routine
iom_deinit	dw	?		; offset of de-init routine
iom_input	dw	?		; offset of input routine
iom_output	dw	?		; offset of output routine
iom_interrupt	dd	?		; interrupt callback vector
iom_reserved	dw	8 dup (?)	; reserved, zero
IOMAPB		ends

;	Note that routines not used need not have "stubs"; an all-zero
;	offset will be ignored by 22Nice.

	IOMAPB	<IOMAP_SIGNATURE, offset Init, offset DeInit, offset Input,\
		 offset Output, 0>

;	The Init routine is called before any program code is actually
;	executed.

Init		proc	far
	ret
Init		endp

;	The DeInit routine is called after the program execution has
;	terminated.  Both normal and error termination go through here.

DeInit		proc	far
	ret
DeInit		endp

;	I/O processors have the I/O port in (bl) and the data byte in (al).
;	Any registers may be used, but the stack must be preserved.  Output
;	preserves (AL), and Input expects the I/O data to be returned in
;	(AL).

Input		proc	far
	ret
Input		endp

Output		proc	far
	ret
Output		endp

;	The interrupt callback vector is used by 80x86 interrupt servicers
;	that want to emulate a Z-80 or 8080 interrupt.	To enable the
;	interrupt handling, the iom_interrupt field in the IOMAPB block
;	must be assembled as non-zero to show that interrupt emulation
;	processing is required by this map.
;
;	After 22nice has completed loading the emulated program, a
;	doubleword pointer to a two-byte word will be inserted in the
;	iom_interrupt field.
;
;	When an interrupt is processed by the 80x86 handler, a Z-80 or
;	8080 interrupt may be emulated by storing the Z-80 or 8080
;	P-counter value into the word pointed to by iom_interrupt.
;	The emulation software will read this value, simulate an
;	interrupt and set the value pointed to by iom_interrupt to zero.
;	This means that you can interrupt to any location except 0000.


	end
