;File:	RDOS.ASM
;Edit date:	86/12/12.
;Serial number 33
;
;	RDOS - Resident disk operating system.
;
;	Copyright (c) 1985 by microMethods
;			      P.O. Box G
;			      Warrenton, Oregon  97146
;
;	Reserved locations.
;
RWBT	EQU	0000H	;warmboot vector
IOBT	EQU	0003H	;Intel "I/O byte"
RBLK	EQU	003BH	;flaw table record block
RBUF	EQU	0080H	;resident default buffer
;
;	Assembly constants.
;
VERN	EQU	5	;RDOS revision level
RECSIZ	EQU	80H	;record size
MEMSIZ	EQU	64	;memory size in k bytes
MEMPAG	EQU	MEMSIZ*4	;memory size in pages
BIOSIZ	EQU	3+12		;CBIOS size in pages
RDOSIZ	EQU	14		;RDOS size in pages
RCPSIZ	EQU	8		;RCP size in pages
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
;	Assembly options.
;
USRCOM	EQU	TRUE	;all users may access USER 0 files
FLAWTB	EQU	TRUE	;save block name for flaw table
;
;	Assembler calculated memory map.
;
BIOFWA	EQU	(MEMPAG-BIOSIZ)*100H	;CBIOS fwa
RDOFWA	EQU	BIOFWA-(RDOSIZ*100H)	;RDOS fwa
RCPFWA	EQU	RDOFWA-(RCPSIZ*100H)	;RCP fwa
;
;	CBIOS entry points.
;
BIOCBT	EQU	BIOFWA		;coldboot
BIOWBT	EQU	BIOCBT+3	;warmboot
BIOCST	EQU	BIOWBT+3	;console status
BIOCIN	EQU	BIOCST+3	;console input
BIOCOT	EQU	BIOCIN+3	;console output
BIOLOT	EQU	BIOCOT+3	;list output
BIOPUN	EQU	BIOLOT+3	;punch output
BIORIN	EQU	BIOPUN+3	;reader input
BIOHOM	EQU	BIORIN+3	;set track zero
BIOSEL	EQU	BIOHOM+3	;select disk
BIOTRK	EQU	BIOSEL+3	;set track
BIOSEC	EQU	BIOTRK+3	;set sector
BIODMA	EQU	BIOSEC+3	;set DMA
BIORDR	EQU	BIODMA+3	;read record
BIOWDR	EQU	BIORDR+3	;write record
BIOLST	EQU	BIOWDR+3	;list status
BIOSTR	EQU	BIOLST+3	;sector skew
;
;
;	ASCII character codes.
;
RUBOUT	EQU	7FH	;delete
CR	EQU	0DH	;carriage return
LF	EQU	0AH	;line feed
ASCCC	EQU	03H	;control-c
ASCCS	EQU	13H	;control-s
ASCCP	EQU	10H	;control-p
ASCBS	EQU	08H	;control-h = backspace
ASCTB	EQU	09H	;control-i = tab
ASCCE	EQU	05H	;control-e
ASCCX	EQU	18H	;control-x
ASCCU	EQU	15H	;control-u
ASCCR	EQU	12H	;control-r
;
;
	ORG	RDOFWA
;
	JMP	FCC	;RCP vector to FCC
	JMP	AWT	;RCP vector to AWT
	JMP	RPM	;RDOS entry point
;
;	Address table of error condition processors.
;
RPMA	EQU	$
	DW	PDE	;"Bad sector"
	DW	PDE1	;"Select"
	DW	PDE2	;"R/O" (disk)
	DW	PDE3	;"File R/O"
;
;	Dismountable disk drives vector.
;	Drive bit = 1  dismountable
;		  = 0  nondismountable
;
HDVEC:	DW	0FFFEH	;keep drive A logged in
DIRAC:	DB	0	;directory access flag
;
;	Directory hash table processor.
;	PDA - Process directory address.
;	Get or put directory ordinal.
;	Entry	 A = hash code
;		 C = 0  get directory ord(A)
;		 C = 1  put directory ord(A)
;		HL = directory ordinal for put
;	Exit	HL = directory ordinal, if get
;
PDA:	JMP	CAI	;HL=dirord
DIRORD:	DW	0	;directory ordinal
;
;	RPMB - Address table.
;	Resident function processors.
;
RPMB	EQU	$
	DB	0	;current function
	DW	BIOWBT	; 0  00  warmboot
	DW	RFCIN	; 1  01  console input
	DW	RFCOT	; 2  02  console output
	DW	RFRIN	; 3  03  reader input
	DW	BIOPUN	; 4  04  punch output
	DW	BIOLOT	; 5  05  list output
	DW	RFDIO	; 6  06  direct console I/O
	DW	RFGL3	; 7  07  get "iobyte"
	DW	RFSL3	; 8  08  set "iobyte"
	DW	RFCBO	; 9  09  console buffer out
	DW	RFCBI	;10  0A  console buffer in
	DW	RFCST	;11  0B  console status
	DW	RFGVN	;12  0C  get version number
	DW	RFRRT	;13  0D  reset reservation tables
	DW	RFSEL	;14  0E  select disk
	DW	RFOPN	;15  0F  open file
	DW	RFCLO	;16  10  close file
	DW	RFSFF	;17  11  search for first occurence
	DW	RFSFN	;18  12  search for next occurence
	DW	RFDEL	;19  13  delete file
	DW	RFRSR	;20  14  read sequential record
	DW	RFWSR	;21  15  write sequential record
	DW	RFCNF	;22  16  create new file
	DW	RFREN	;23  17  rename file
	DW	RFRLV	;24  18  return log-in vector
	DW	RFRCD	;25  19  return current disk
	DW	RFDMA	;26  1A  set DMA address
	DW	RFGRA	;27  1B  get RBR address
	DW	RFWPD	;28  1C  write protect disk
	DW	RFGRO	;29  1D  get read-only vector
	DW	RFSAT	;30  1E  set file attributes
	DW	RFDPB	;31  1F  get DPB address
	DW	RFPUN	;32  20  process user number
	DW	RFRRR	;33  21  read random record
	DW	RFWRR	;34  22  write random record
	DW	RFCFS	;35  23  compute file size
	DW	RFSRR	;36  24  set random record address
	DW	RFCLV	;37  25  clear log-in vector bits
	DW	RFPAG	;38  26  set display page size
	DW	RFUND	;39  27  (spare)
	DW	RFWRZ	;40  28  write random with zero fill
RPMC	EQU	($-RPMB)/2	;max function number
;
;
;	Data space.
;
BSFLAG:	DB	0	;backspace marker
CCOL:	DB	0	;starting column
TABC:	DB	0	;tab counter=current column
LISTF:	DB	0	;list flag toggled by control-p
NCHAR:	DB	0	;next character
LINEC:	DB	0	;line counter
PAGES:	DB	0	;page size
OLDSP:	DW	0	;user's stack pointer
;
;	RDOS stack area.
;
	DB	'Copyright (c) 1985 by microMethods.$'
	DB	VERN+'A'-1
	DS	2*24+OLDSP+2-$
STACK	EQU	$
;
CUSER:	DB	0	;current USER number
CDISK:	DB	0	;current disk
EARGDE:	DW	0	;entry value of DE
RARGA	EQU	$
RARGHL:	DW	0	;reply returned in AB and HL
;
;
;	RPM - Resident program manager.
;	Entry	 C = function number
;		 E = byte argument, or
;		DE = word argument
;
RPM:	MOV	A,E	;save byte argument
	STA	EARGE
	XCHG		;save word argument
	SHLD	EARGDE
;
	LXI	H,0000	;preset reply argument
	SHLD	RARGHL
	SHLD	PDSCF	;clear autosel & PDS call
;
	DAD	SP	;save user's stack
	SHLD	OLDSP
	LXI	SP,STACK
;
	LXI	H,RTC	;set return processor on stack
	PUSH	H
	MOV	A,C	;check function defined
	CPI	RPMC
	RNC		;If undefined
;
	LXI	H,RPMB	;address table of function processors
	MOV	M,C	;save current function
	INX	H
	CALL	AWT
	LHLD	EARGDE
	XCHG		;DE=fcb fwa  HL=processor address
	MOV	C,E	;C=byte entry argument
	PCHL		;go process function
;
;
;	PDE - Process disk error.
;	Warmboot optional.
;
PDE	EQU	$
	IF	FLAWTB
	CALL	GBL	;save block for flaw table
	SHLD	RBLK
	ENDIF
	LXI	H,PDEC	;"Bad sector"
PDE0:	CALL	PEM	;display msg and get response
	CPI	ASCCC
	JZ	0000	;If control-c
	RET
;
;	PDE1 - Process disk select error.
;	Warmboot.
;
PDE1:	LXI	H,PDED	;"Select"
	JMP	PDE4
;
;	PDE2 - Process drive READ-ONLY error.
;	Warmboot optional.
;
PDE2:	LXI	B,0000	;log out CDISK
	CALL	SVB
	CALL	CDV
	CALL	LDC	;log in CDISK
	LXI	H,PDEF	;"swap ok?"
	JMP	PDE0
;
;	PDE3 - Process file READ-ONLY error.
;	Warmboot.
;
PDE3:	LXI	H,PDEE	;"File R/O"
PDE4:	CALL	PEM	;display message
	JMP	0000
;
;	Error message text.
;
PDEA:	DB	'Disk error on '
PDEB:	DB	'd: $'
PDEC:	DB	'bad sector$'
PDED:	DB	'Select$'
PDEE:	DB	'File R/O$'
PDEF:	DB	'Swap ok?$'
;
;	PEM - Process error message and get response.
;	Entry	HL = message fwa
;
PEM:	PUSH	H
	CALL	EOL	;cr,lf
	LDA	CDISK	;put drive letter in message
	ADI	'A'
	STA	PDEB
;
	LXI	H,PDEA	;"Disk error on d:"
	CALL	MSG
	POP	H
	CALL	MSG
;
;	GCC - Get console character.
;	Exit	 A = character
;
GCC:	LXI	H,NCHAR	;check char waiting
	MOV	A,M
	MVI	M,0
	ORA	A
	RNZ		;If a char was waiting
;
	JMP	BIOCIN	;CBIOS console input
;
;	CIE - Console input with echo.
;	Exit	 A = character
;
CIE:	CALL	GCC	;get character
	CALL	FCC	;filter nonpositioning control codes
	RC		;If nonpositioning control code
;
;	Echo graphic or positioning control code to console.
;
	PUSH	PSW
	CALL	CCO0
	POP	PSW
	RET
;
;	FCC - Filter control codes.
;	Entry	 A = char
;	Exit	 A = char
;		Carry set if control code other
;		than cr, lf, tab or backspace.
;
FCC:	CPI    CR ! RZ	;If cr
	CPI    LF ! RZ	;If lf
	CPI ASCTB ! RZ	;If tab
	CPI ASCBS ! RZ	;If bs
	CPI   ' ' ! RET
;
;	BRK - Console break.
;	Exit	 A = 1, if console key hit
;
BRK:	LDA	NCHAR
	ORA	A
	JNZ	BRK4	;If char waiting
;
	CALL	BIOCST	;CBIOS console status
	ANI	01
	RZ		;If no key pressed
;
;	Read the character.
;
	CALL	BIOCIN	;CBIOS console input
	CPI	ASCCS
	JNZ	BRK3	;If not control-s
;
;	Process control-s pause.
;	Control-s followed by control-c will warmboot.
;
BRK1:	CALL	BIOCIN		;CBIOS console input
	CPI ASCCC ! JZ 0000	;If control-c
	CPI ASCCP ! JNZ BRK2	;If not control-p
;
;	TLF - Toggle list flag.
;
TLF:	LDA	LISTF
	CMA
	STA	LISTF
;
;	Continue processing
;
BRK2:	XRA	A
	RET
;
;	Process normal break.
;
BRK3:	STA	NCHAR
BRK4:	MVI	A,1
	RET
;
;	TB0 - Console output with tab column update.
;	Entry	 C = char
;
TBO:	LDA	BSFLAG
	ORA	A
	JNZ	TBO1	;If processing a backspace
;
	PUSH	B
	CALL	BRK	;check console break
	POP B ! PUSH B
	CALL	BIOCOT	;CBIOS console output
	POP B ! PUSH B
	LDA	LISTF
	ORA	A
	CNZ	BIOLOT	;If list flag set
	POP	B
;
TBO1:	MOV	A,C
	LXI	H,TABC	;adjust current column
	INR	M
	CPI	' '
	RNC		;If not a control code
;
;	We have a control code.
;
	DCR	M
	MOV	A,M	;this is where we are
	ORA	A
	MOV	A,C
	JZ	TBO2	;If at beginning of line
;
;	We are not at the beginning of a line.
;
	DCR	M
	CPI RUBOUT! RZ	;If rubout
	CPI ASCBS ! RZ	;If backspace
	INR	M
;
TBO2:	CPI	LF
	RNZ		;If not linefeed
;
;	We are at an end-of-line.
;
	MVI	M,0	;reset current column
	LXI	H,PAGES	;page size
	MOV	A,M
	ORA	A
	RZ		;If paging disabled
;
;	Advance line count.
;
	DCX	H
	DCR	M
	RNZ		;If not end of page
;
;	Reset line count and pause.
;
	MOV	M,A
	JMP	BRK1
;
;	CCO - Console character out.
;	Entry	 C = character
;
CCO:	MOV	A,C
	CALL	FCC	;filter control codes
	JNC	CCO1	;If graphic or positioner
;
;	Echo control code with up-arrow.
;
	PUSH	PSW
	MVI	C,'^'
	CALL	TBO
	POP	PSW
	ORI	'A'-1	;convert to graphic
;
;	Entry	 A = char
;
CCO0:	MOV	C,A
;
;	Process function 2.
;	Console output.
;
RFCOT	EQU	$
;
CCO1:	MOV	A,C
	CPI	ASCTB
	JNZ	TBO	;If not tab
;
;	We have a TAB character.
;
CCO2:	MVI	C,' '	;expand tab
	CALL	TBO
	LDA	TABC	;check display line position
	ANI	7
	JNZ	CCO2	;loop to next tab stop
	RET
;
;	CLC - Clear previous character.
;	Backspace, space, backspace.
;
CLC:	CALL	CLC1	;backspace
	MVI	C,' '	;space
	CALL	BIOCOT
CLC1:	MVI	C,ASCBS	;backspace
	JMP	BIOCOT
;
;	RDL - Restore display line.
;
RDL:	CALL	EOL	;cr,lf
;
;	Restore display to the beginning column.
;
RDL1:	LDA	TABC	;this is where we are
	LXI	H,CCOL	;this is where we are going
	CMP	M
	RNC		;If repositioned
;
	MVI	C,' '
	CALL	TBO
	JMP	RDL1
;
;	EOL - End of line.
;	Issue carriage return, line feed.
;
EOLA:	DB	cr,lf,'$'
;
EOL:	LXI	D,EOLA
;
;	Process function 9.
;	Console buffer out.
;
RFCBO	EQU	$
	XCHG		;null msg returns DE=.RFCBO
;
;	MSG - Console message display.
;	Entry	HL = message fwa
;	Message ends with $
;
MSG:	MOV	A,M
	CPI	'$'
	RZ		;If end of message
;
	INX	H
	PUSH	H
	CALL	CCO0
	POP	H
	JMP	MSG
;
;	PCB - Process console buffer in.
;
;	Process function 10.
;	Console buffer in.
;
RFCBI	EQU	$
PCB:	LDA	TABC	;save our position
	STA	CCOL
	LHLD	EARGDE	;get buffer size from buf(0)
	MOV	C,M
	INX	H
	PUSH	H	;save address of buf(1)
	MVI	B,0	;preset char count
;
PCB1:	PUSH B ! PUSH H
PCB2:	CALL	GCC	;get console char
	ANI	0FFH
	POP H ! POP B
;
	CPI    CR ! JZ  PCB17	;If cr
	CPI    LF ! JZ  PCB17	;If lf
	CPI RUBOUT! JZ  PCB3	;If rubout
	CPI ASCBS ! JNZ PCB4	;If not backspace
;
;	Process backspace.
;
PCB3:	MOV	A,B
	ORA	A
	JZ	PCB1	;If at beginning of line
;
	DCR	B
	LDA	TABC	;save current column
	STA	BSFLAG
	JMP	PCB10
;
PCB4:	CPI	ASCCE
	JNZ	PCB5	;If not control-e
;
;	Process control-e.
;	Move to new display line.
;
	PUSH B ! PUSH H
	CALL	EOL	;new line
	XRA	A	;reset current starting column
	STA	CCOL
	JMP	PCB2
;
PCB5:	CPI	ASCCP
	JNZ	PCB6	;If not control-p
;
;	Process control-p.
;	Toggle the list flag.
;
	CALL	TLF
	JMP	PCB1
;
PCB6:	CPI	ASCCX
	JNZ	PCB8	;If not control-x
;
;	Process control-x.
;	Cancel buffer without line advance.
;
	POP	H
PCB7:	LDA	CCOL	;starting column
	LXI	H,TABC
	CMP	M	;start-current
	JNC	PCB	;If back to starting column
;
	DCR	M	;move current column back one
	CALL	CLC	;backspace, space, backspace
	JMP	PCB7
;
PCB8:	CPI	ASCCU
	JNZ	PCB9	;If not control-u
;
;	Process control-u.
;	Recall previous text.
;
	MOV	B,M	;character count
	JMP	PCB10
;
PCB9:	CPI	ASCCR
	JNZ	PCB14	;If not control-r
;
;	Process control-r.
;	Move to new line and display current buffer.
;
PCB10:	PUSH	B
	CALL	RDL	;new line
	POP	B
	POP H ! PUSH H	;HL=string fwa
	PUSH	B
;
PCB11:	MOV	A,B
	ORA	A
	JZ	PCB12	;If end of buffer
;
	INX	H
	MOV	C,M
	DCR	B
	PUSH B ! PUSH H
	CALL	CCO
	POP H ! POP B
	JMP	PCB11
;
;	Back up to the backspace marker.
;
PCB12:	PUSH	H
	LDA	BSFLAG	;backspace marker
	ORA	A
	JZ	PCB2	;If no backspace done
;
	LXI	H,TABC
	SUB	M	;backspace marker-current position
	STA	BSFLAG	;spaces to go back
PCB13:	CALL	CLC	;backspace, space, backspace
	LXI	H,BSFLAG
	DCR	M
	JNZ	PCB13	;loop back to backspace marker
	JMP	PCB2
;
;	Store the character in calling program's buffer.
;
PCB14:	INX	H
	MOV	M,A
	INR	B	;advance char count
;
PCB15:	PUSH B ! PUSH H
	MOV	C,A
	CALL	CCO	;echo character to console
	POP H ! POP B
	MOV	A,M
	CPI	ASCCC
	MOV	A,B
	JNZ	PCB16	;If not control-c
;
;	We have a control-c.
;	If this is the first character typed, then warmboot.
;
	CPI	1
	JZ	0000	;If first char typed
;
PCB16:	CMP	C	;buffer size
	JC	PCB1	;If not end of buffer
;
;	We are at the end of the user's buffer.
;
PCB17:	POP	H	;buffer fwa+1
	MOV	M,B	;set char count
	MVI	C,CR
	JMP	TBO
;
;	Process function 1.
;	Console character input.
;
RFCIN	EQU	$
	CALL	CIE	;console in with echo
	JMP	RBV	;return byte value
;
;	Process function 3.
;	Reader input.
;
RFRIN	EQU	$
	CALL	BIORIN	;CBIOS reader in
	JMP	RBV	;return byte value
;
;	Process function 6.
;	Direct console input and output.
;	Entry	 E = FF  input or return 00
;		   = FE  input with wait
;		   = xx  output char xx
;
RFDIO	EQU	$
	MOV	A,C
	INR	A
	JZ	DIO1	;If input
;
	INR	A
	JZ	DIO2	;If read w/wait
;
	JMP	BIOCOT	;output char xx
;
;	Process direct console input.
;
DIO1:	CALL	BIOCST	;check console status
	ORA	A
	JZ	RTC1	;If no data available
;
;	Wait for character, then input.
;
DIO2:	CALL	BIOCIN	;read console char
	JMP	RBV	;return byte value
;
;	Process function 7.
;	Process function 8.
;	Set or get Intel "iobyte".
;
RFGL3	EQU	$
	LDA	3
	JMP	RBV	;return byte value
;
RFSL3	EQU	$
	MOV	A,C
	STA	3
	RET
;
;
;	Process function 11.
;	Get console status.
;
RFCST	EQU	$
	CALL	BRK
	JMP	RBV	;return byte value
;
;	Process disk select error.
;
JPI0:	LXI	H,RPMA+2	;processor address
;
;	JPI - Jump indirect to (HL).
;	Entry	HL = indirect address
;
JPI:	MOV E,M ! INX H
	MOV D,M
	XCHG
	PCHL
;
;	MDB - Move directory buffer.
;	Move 128 bytes from dirbuf to user's buffer.
;
MDB:	LHLD	DIRLOC
	XCHG
	LHLD	USRDMA
	MVI	C,128
;
;	MCB - Move C bytes.
;	Entry	DE = source fwa
;		HL = destination fwa
;		 C = byte count
;
MCB:	INR	C
MCB1:	DCR	C
	RZ		;If done
;
	LDAX D ! MOV M,A
	INX  D ! INX H
	JMP	MCB1
;
;	AWT - Access a word table.
;	ABT - Access a byte table.
;	Entry	HL = table fwa
;		 A = ordinal
;	Exit	DE = word table entry
;		 E = byte table entry
;		HL = table entry address
;
AWT:	ADD	A
ABT:	MOV	E,A
	MVI	D,0
	DAD	D
	MOV E,M ! INX H
	MOV D,M ! DCX H
	RET
;
;	SDC - Select CDISK.
;	Entry	HL = rotated log-in vector
;	Exit	 A = true (FF) if select completed
;		   = false (00) if no select
;		 Z set by (A)
;
SDC:	LDA	CDISK
	MOV	C,A
	XCHG		;E=log-in bit
	CALL	BIOSEL	;CBIOS select disk
	MOV	A,H
	ORA	L
	RZ		;If device undefined
;
;	Copy disk parameters.
;
	MOV E,M ! INX H ! MOV D,M ! INX H
;
;	DE=skew table fwa
;
	SHLD	DTMP1	;.logical end of directory
	XCHG
	SHLD	XLTAB	;skew table fwa
	LXI	H,6
	DAD	D
	XCHG
;
;	DE = location of directory buffer address.
;	Move DIRBUF, DPB, CSV, and RBR pointers.
;
	LXI	H,DIRLOC
	MVI	C,2*4
	CALL	MCB
;
;	DPBLOC now contains DPB fwa.
;	Move the disk parameter block.
;
	LHLD	DPBLOC
	XCHG
	LXI	H,DPBFWA
	MVI	C,15
	CALL	MCB
;
;	Check RBT bytes or words.
;
	LHLD	DPBDSM	;max block number
	MOV	A,H
	LXI	H,RBTBF	;set byte flag true for RBT bytes
	MVI	M,0FFH
	ORA	A
	JZ	SDC1	;If RBT bytes used for this disk
;
;	The RBT contains 16-bit words.
;
	MVI	M,00	;mark byte flag false
;
;	Indicate disk select operations completed.
;
SDC1:	MVI	A,0FFH
	ORA	A
	RET
;
;
;	RDR - Read disk record.
;
RDR:	CALL	BIORDR	;CBIOS read disk record
	JMP	WDR1
;
;	WDR - Write disk record.
;	Entry	 C = CBIOS pre-read code
;
WDR:	CALL	BIOWDR	;CBIOS write disk record
WDR1:	ORA	A
	RZ		;If no error
;
;	We have an error indicated by CBIOS.
;
	IF	FLAWTB
	STA	RBLK+2	;save CBIOS disk status
	ENDIF
	LXI	H,RPMA	;pointer to error processor
	JMP	JPI
;
;	PPD - Process position disk.
;	Directory access.
;	Entry	DIRORD = directory ordinal
;
PPD:	LHLD	DIRORD	;record ordinal=directory ord/4
	MVI	C,2
	CALL	HRC
	SHLD	DRORD	;disk record ordinal
	SHLD	RECORD	;save for checksum processor
	XRA	A
	STA	DRORD+2
;
;	General access.
;	Entry	DRORD = 23-bit disk record ordinal
;
PPD1:	LHLD	DPBSPT	;BC=sectors/track
	MOV	C,L
	MOV	B,H
	LHLD	DRORD	;HLDE=record ordinal
	XCHG
	LHLD	DRORD+2
	MVI	H,0
	CALL	DIV	;DE=track, HL=sector
	PUSH	H	;save sector
;
	LHLD	DPBOFF	;add track offset
	DAD	D
	MOV	C,L
	MOV	B,H
	CALL	BIOTRK	;CBIOS set track
;
	POP	B	;apply sector translate
	LHLD	XLTAB
	XCHG
	CALL	BIOSTR	;CBIOS sector translate
;
	MOV	C,L
	MOV	B,H
	JMP	BIOSEC	;CBIOS set sector
;
;	CFO - Calculate first record ordinal.
;	Exit	AHL = ord, 1st rec of block
;
CFO:	LDA	DPBBSH	;multiply by rec/blk
	MOV	C,A
	LHLD	RBTENT	;block number
	XRA	A
;
CFO1:	DAD	H
	RAL
	DCR	C
	JNZ	CFO1	;loop for rec/blk mult
	RET
;
;	CRO - Calculate 23-bit record ordinal.
;	Exit	AHL = blk*rec per blk + cr.blkmask
;
CRO:	CALL	CFO	;AHL=blk*rec per blk
	PUSH	PSW
	LDA	DPBBLM	;block mask
	MOV	C,A
	LDA	FCBCR	;current record
	ANA	C
;
	ORA	L
	MOV	L,A
	POP	PSW
	SHLD	DRORD
	STA	DRORD+2
	RET
;
;	DIV - Divide.
;	Entry	HL,DE = dividend
;		   BC = divisor
;	Exit	   DE = quotient
;		   HL = remainder
;
DIV:	MOV A,L ! SUB C ! MOV A,H ! SBB B
	RNC				;If quotient>FFFF
	MOV A,B ! CMA   ! MOV B,A 	;2s complement BC
	MOV A,C ! CMA   ! MOV C,A ! INX B
	CALL	DIV1
;
DIV1:	MOV A,D ! MOV D,E ! MVI E,8
DIV2:	DAD H   ! JC DIV5		;If high bit set
	ADD A   ! JNC DIV3		;If no carry
	INX H				;convey carry
DIV3:	PUSH H  ! DAD B ! JC DIV4	;If no borrow
	POP H   ! DCR E ! JNZ DIV2	;loop until done
	MOV E,A ! STC   ! RET
;
DIV4:	INX SP ! INX SP ! INR A ! DCR E
	JNZ	DIV2			;loop until done
	MOV E,A ! STC  ! RET
;
DIV5:	ADC A ! JNC DIV6		;If no carry
	INX	H			;convey carry
DIV6:	DAD B ! DCR E ! JNZ DIV2	;loop until done
	MOV E,A ! STC  ! RET
;
;	FRO - Form RBT ordinal.
;	Entry	LEXT = current logical extent
;		     = ext .and. ext mask
;		FCBCR = fcb current record
;	Exit	 A = RBT entry ordinal
;		   = lext * (blks/lext) + cr / (recs/blk)
;		   = SHL(lext,8-bsh-1) + SHR(cr,bsh)
;		 C = block shift, bsh
;
;	Blk size  recs/blk  bsh  8-bsh-1  blk/lext
;	   1k        8       3      4        16
;	   2k       16       4      3         8
;	   4k       32       5      2         4
;	   8k       64       6      1         2
;	  16k      128       7      0         1
;
;
FRO:	LXI	H,DPBBSH	;block ord=cur rec/recs per blk
	MOV	C,M
	LDA	FCBCR
FRO1:	ORA	A
	RAR
	DCR	C
	JNZ	FRO1	;loop for block shift bits
;
	MOV	B,A
;
;	B = block ordinal within logical extent.
;	Use complement of block shift to position
;	to current logical extent.
;
	MVI	A,8	;C=8-block shift
	SUB	M
	MOV	C,A
	LDA	LEXT	;logical extent
FRO2:	DCR	C
	JZ	FRO3	;If positioned
;
	ORA	A
	RAL
	JMP	FRO2
;
FRO3:	ADD	B
	RET
;
;	RBE - Get RBT entry.
;	Entry	BC = entry ordinal
;	Exit	HL = RBT byte or word
;
RBE:	LHLD	EARGDE	;fcb fwa
	LXI	D,16
	DAD	D	;HL=RBT fwa
	DAD	B
;
;	Check RBT byte or word processing.
;
	LDA	RBTBF	;byte flag
	ORA	A
	JZ	RBE1	;If RBT words
;
;	RBT bytes are being processed.
;
	MOV	L,M
	MVI	H,0
	RET
;
;	RBT words are being processed.
;
RBE1:	DAD	B
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	RET
;
;	GBL - Get record block.
;	Exit	RBTENT = block(cr)
;
GBL:	CALL	FRO	;form RBT ordinal for cr
	MOV	C,A
	MVI	B,0
	CALL	RBE	;HL=RBT entry
	SHLD	RBTENT
	RET
;
;	CBE - Check RBT empty.
;	Exit	 Z = true, if RBTENT empty
;		 Z forced false, if directory
;		   access enabled
;
CBE:	LHLD	RBTENT
	LDA	DIRAC
	ORA	L
	ORA	H
	RET
;
;	GS2 - Get fcb byte s2.
;	Exit	 A = s2
;		HL = .s2
;
GS2:	CALL	AEX	;HL=.fcb ex
	INX H ! INX H
	MOV	A,M
	RET
;
;	CS2 - Clear fcb byte s2.
;	Exit	 A = s2
;		s2 cleared
;
CS2:	CALL	GS2	;get s2
	MVI	M,0
	RET
;
;	AEX - Address the extent byte.
;	Exit	HL = address of ext byte in fcb
;
AEX:	LXI	D,12	;ext ord
AEX1:	LHLD	EARGDE	;fcb fwa
	DAD	D
	RET
;
;	ARC - Address fcb record counters.
;	Exit	HL = address of next record
;		DE = address of record count
;
ARC:	LXI	D,15	;rc
	CALL	AEX1
	XCHG
;
	LXI	H,32-15	;nr
	DAD	D
	RET
;
;	RID - Get record ID values from fcb.
;
RID:	CALL	ARC	;get rc, nr locations
	MOV	A,M
	STA	FCBCR	;fcb cr = nr
;
	XCHG		;set record count
	MOV	A,M
	STA	FCBRC
;
	CALL	AEX	;form local extent
	LDA	DPBEXM	;extent mask
	ANA	M
	STA	LEXT
	RET
;
;	RSR - Read sequential record.
;
RSR:	MVI	A,1	;set access flag=seq
	STA	ACFLAG
;
;	Random & sequential access.
;
RSR1:	XRA	A	;disable extent mask
	STA	ENEXM
	CMA		;indicate read
	STA	RDSEQ
	CALL	RID	;get current record ID
	LDA	FCBCR	;current record
	LXI	H,FCBRC	;record count
	CMP	M
	JC	RSR2	;If record within current ext
;
;	Process sequential access.
;	The next logical extent is required.
;
	CPI	80H
	JNZ	RBV1	;If non-existent record
;
;	Open next logical extent.
;
	CALL	AFX0	;advance logical extent
	XRA	A	;reset current record
	STA	FCBCR
;
	LDA	RARGA	;check extent advanced
	ORA	A
	JNZ	RBV1	;If past eoi
;
;	Calculate record ordinal for current record.
;
RSR2:	CALL	GBL	;get record block
	CALL	CBE	;check block empty
	JZ	RBV1	;If past eoi
;
	CALL	CRO	;calculate record ordinal
	CALL	PPD1	;position disk
	MVI	C,0	;CBIOS flag=normal read
	CALL	RDR	;read record
;
;	AFR - Advance fcb record counters.
;	Entry	ACFLAG = increment
;		ACFLAG = 2 for random write w/zero fill
;
AFR:	CALL	ARC	;address record bytes
	LDA	ACFLAG	;access type
	CPI	2
	JNZ	AFR1	;If not write w/zero fill
;
;	Set no advance.
;
	XRA	A
AFR1:	MOV	C,A	;nr=fcbcr + increment
	LDA	FCBCR
	ADD	C
	MOV	M,A
;
	XCHG		;copy record count
	LDA	FCBRC
	MOV	M,A
	RET
;
;	HRC - HL shift right C bits.
;
HRC:	INR	C
HRC1:	DCR	C
	RZ		;If done
;
	ORA	A
	MOV A,H ! RAR ! MOV H,A
	MOV A,L ! RAR ! MOV L,A
	JMP	HRC1
;
;	CCS - Calculate directory sector checksum.
;	Exit	 A = checksum
;
CCS:	MVI	C,128	;byte count
	LHLD	DIRLOC	;directory buffer fwa
	XRA	A
;
CCS1:	ADD	M
CCS2:	INX	H
	DCR	C
	JNZ	CCS1	;loop over buffer
	RET
;
;	HLC - HL shift left C bits.
;
HLC:	INR	C
HLC1:	DCR	C
	RZ		;If done
;
	DAD	H
	JMP	HLC1
;
;	SVB - Set vector bit for CDISK.
;	Entry	BC = old vector
;	Exit	HL = new vector with CDISK bit set
;
SVB:	PUSH	B
	LDA	CDISK
	MOV	C,A
	LXI	H,0001
	CALL	HLC	;shift HL CDISK bits left
	POP	B
	MOV A,C ! ORA L ! MOV L,A
	MOV A,B ! ORA H ! MOV H,A
	RET
;
;	GDI - Get CDISK log-in bit.
;	Exit	HL = rotated log-in vector
;		 A, low bit = CDISK log-in bit
;		 Z = false, if CDISK logged in
;
GDI:	LHLD	LGVEC
	JMP	DRO1
;
;	DRO - Check CDISK read-only.
;	Exit	 A = 01 if CDISK marked R/O
;
DRO:	LHLD	ROVEC
DRO1:	LDA	CDISK
	MOV	C,A
	CALL	HRC	;shift the CDISK bit low
	MOV	A,L
	ANI	01
	RET
;
%RDOS1.ASM
