;File:	RASM5.ASM
;Edit date:	86/10/04.
;Serial number 5
;
;	RP/M2 Assembler expression evaluation module.
;
EVAORG	EQU	2D00H
MTPORG	EQU	2A00H
STMORG	EQU	2700H
SCNORG	EQU	2400H
IOMORG	EQU	0300H
;
;	Entry points in the I/O module.
;
IOMPER	EQU	IOMORG+18H	;put print line error flag
;
;	Entry points in the scanner module.
;
SCNSNT	EQU	SCNORG+06H	;scan next token
;
;	Entry points in the symbol table module.
;
STMSFS	EQU	STMORG+06H	;search for symbol
STMCSF	EQU	STMSFS+3	;check symbol found
STMEST	EQU	STMCSF+3	;enter symbol into table
STMSTY	EQU	STMEST+3	;set symbol type
STMGTY	EQU	STMSTY+3	;get symbol type
STMSSV	EQU	STMGTY+3	;set symbol value
STMGSV	EQU	STMSSV+3	;get symbol value
;
;	Entry points in the mnemonics table processor.
;
MTPBSM	EQU	MTPORG+03H	;binary search for mnemonic
MTPGMV	EQU	MTPBSM+3	;get mnemonic type and value
;
;	Locations on page 1.
;	Print line buffer.
;
PLBFWA	EQU	010CH	;line buffer fwa
PLBSIZ	EQU	120	;line length
PLBFBP	EQU	PLBFWA+PLBSIZ	;buffer fill pointer
FPRCOL	EQU	16	;source line image starting column
;
;	Assembler control data.
;
TOKEN	EQU	PLBFBP+1	;current token
VALUE	EQU	TOKEN+1		;binary value
ACCLEN	EQU	VALUE+2		;accumulator length
ACCUM	EQU	ACCLEN+1	;accumulator fwa
ACCSIZ	EQU	64
EVALUE	EQU	ACCUM+ACCSIZ	;expression value
SYTOP	EQU	EVALUE+2	;current symbol table top
SYMAX	EQU	SYTOP+2		;symbol table lwa + 1
PASSN	EQU	SYMAX+2		;pass number, 0 or 1
HEXPC	EQU	PASSN+1		;current hex fill address
LOCCN	EQU	HEXPC+2		;assembler's location counter
SYBAS	EQU	LOCCN+2		;symbol table base
SYADR	EQU	SYBAS+2		;current symbol address
FIXED	EQU	7		;collision+length+value
;
;	Ascii character codes.
;
cr	EQU	0DH		;carriage return
lf	EQU	0AH		;line feed
eof	EQU	1AH		;control-z = end of file
tab	EQU	09H		;tabulate
;
;	Token definitions.
;
IDENT	EQU	1	;identifier
NUMBR	EQU	2	;number
STRNG	EQU	3	;string
SPECL	EQU	4	;other
;
;	Symbol types.
;
TCLB	EQU	 1	;code label
TDLB	EQU	 2	;data label
TEQU	EQU	 4	;defined by EQU
TSET	EQU	 5	;defined by SET
TMAC	EQU	 6	;defined by MACRO
TEXT	EQU	 8	;defined by EXT
TREF	EQU	11	;defined by REF
TGBL	EQU	12	;defined by GLOBAL
;
XBASE	EQU	0	;start of operator types
LOPER	EQU	15	;last operator
RT	EQU	16	;register type
PT	EQU	RT+1	;pseudo-operation type
OBASE	EQU	PT+1	;start of operations types
;
PLUS	EQU	5
MINUS	EQU	6
NOTF	EQU	8
LPAR	EQU	12
RPAR	EQU	13
;
;	Operand and operation stack sizes.
;
OSMAX	EQU	5*2	;operator stack
VSMAX	EQU	8*2	;operand stack
;
	ORG	EVAORG
	JMP	ENDEVA
	JMP	SOF	;scan operand field
	JMP	MUL	;mutiply
	JMP	DIV	;divide
;
;	Local data space.
;
UNARY:	DB	0	;true, if next operation is unary
OPERV	EQU	$	;operator stack
	DS	OSMAX
;
HIERV	EQU	$	;priority stack
	DS	OSMAX
;
VSTACK	EQU	$	;operand stack
	DS	VSMAX
OSP:	DB	0	;operator stack pointer
VSP:	DB	0	;operand stack pointer
;
;	PHV - Push value on operand stack.
;	Entry	HL = value
;
PHV:	XCHG
	LXI	H,VSP	;stack pointer
	MOV	A,M
	CPI	VSMAX
	JC	PHV1	;If space available
;
;	Operand stack is full.
;
	MVI	M,0	;reset stack
	CALL	ERX	;issue error "E"
PHV1:	MOV	A,M	;push stack
	INR M ! INR M
	MOV C,A ! MVI B,0
	LXI	H,VSTACK
	DAD	B
	MOV M,E ! INX H
	MOV M,D
	RET
;
;	PHO - Push operator and priority.
;	Entry	 A = operator
;		 B = priority
;
PHO:	PUSH	PSW
	LXI	H,OSP
	MOV	A,M
	CPI	OSMAX
	JC	PHO1	;If space available
;
	MVI	M,0	;reset stack
	CALL	ERX	;issue error "E"
PHO1:	MOV E,M ! MVI D,0
	INR	M	;advance stack pointer
	POP	PSW
	LXI	H,OPERV
	DAD	D
	MOV	M,A
;
;	Push priority.
;
	LXI	H,HIERV
	DAD	D
	MOV	M,B
	RET
;
;	PLV - Pop value from operand stack.
;	Exit	HL = value
;
PLV:	LXI	H,VSP
	MOV	A,M
	ORA	A
	JNZ	PLV1	;If data available
;
;	The operand stack is empty.
;
	CALL	ERX	;issue error "E"
	LXI	H,0
	RET
;
;	Pop operand value.
;
PLV1:	DCR M ! DCR M	;advance stack pointer
	MOV C,M ! MVI B,0
	LXI	H,VSTACK
	DAD	B
	MOV C,M ! INX H
	MOV H,M ! MOV L,C
	RET
;
;	PLV2 - Pop two operands.
;	Exit	DE = (TOS)
;		HL = (TOS-1)
;
PLV2:	CALL	PLV
	XCHG
	CALL	PLV
	RET
;
;	APO - Apply operation to operand stack.
;	Entry	 A = operation
;
APO:	LXI	H,APOA	;operation processor table
	CALL	AWT
	XCHG
	PCHL		;go to processor
;
;	Operation processors.
;
APOA	EQU	$
	DW	PMO	;0  multiply
	DW	PDO	;1  divide
	DW	PMD	;2  MOD
	DW	PSL	;3  SHL
	DW	PSR	;4  SHR
	DW	PAD	;5  addition
	DW	PSB	;6  subtraction
	DW	PNG	;7  negation
	DW	PNT	;8  NOP
	DW	PAN	;9  AND
	DW	POR	;A  OR
	DW	PXR	;B  XOR
	DW	ERX	;C  (spare)
	DW	ERX	;D  (spare)
	DW	ERX	;E  (spare)
	DW	ERX	;F  (spare)
;
;	MUL - Multiply.
;
MUL:	MOV B,H ! MOV C,L
	LXI	H,0
MUL1:	XRA	A	;clear carry
	MOV A,B ! RAR ! MOV B,A
	MOV A,C ! RAR ! MOV C,A
	JC	MUL2	;If lsb=1
;
	ORA B ! RZ	;If done
	JMP	MUL3
;
MUL2:	DAD	D
MUL3:	XCHG		;shift HL left
	DAD	H
	XCHG
	JMP	MUL1
;
;	AWT - Access a word table.
;	ABT - Access a byte table.
;	Entry	HL = table fwa
;		 A = ordinal
;	Exit	DE = word table entry
;		 E = byte table entry
;		HL = table entry address
;
AWT:	ADD	A
ABT:	MOV	E,A
	MVI	D,0
	DAD	D
	MOV E,M ! INX H
	MOV D,M ! DCX H
	RET
;
;	DIV - Divide.
;	Entry	HL,DE = dividend
;		   BC = divisor
;	Exit	   DE = quotient
;		   HL = remainder
;
DIV:	MOV A,L ! SUB C ! MOV A,H ! SBB B
	RNC				;If quotient>FFFF
	MOV A,B ! CMA   ! MOV B,A 	;2s complement BC
	MOV A,C ! CMA   ! MOV C,A ! INX B
	CALL	DIV1
;
DIV1:	MOV A,D ! MOV D,E ! MVI E,8
DIV2:	DAD H   ! JC DIV5		;If high bit set
	ADD A   ! JNC DIV3		;If no carry
	INX H				;convey carry
DIV3:	PUSH H  ! DAD B ! JC DIV4	;If no borrow
	POP H   ! DCR E ! JNZ DIV2	;loop until done
	MOV E,A ! STC   ! RET
;
DIV4:	INX SP ! INX SP ! INR A ! DCR E
	JNZ	DIV2			;loop until done
	MOV E,A ! STC  ! RET
;
DIV5:	ADC A ! JNC DIV6		;If no carry
	INX	H			;convey carry
DIV6:	DAD B ! DCR E ! JNZ DIV2	;loop until done
	MOV E,A ! STC  ! RET
;
;	PMO - Process multiply operation.
;
PMO:	CALL	PLV2	;pop two operands
	CALL	MUL
	JMP	PXR1	;go push product
;
;	PDO - Process divide operation.
;
PDO:	CALL	PLV2	;pop two operands
	XCHG
	MOV B,H ! MOV C,L
	LXI	H,0
	CALL	DIV
	XCHG
	JMP	PXR1	;go push quotient
;
;	PMD - Process MOD operation.
;
PMD:	CALL	PLV2	;pop two operands
	XCHG
	MOV B,H ! MOV C,L
	LXI	H,0
	CALL	DIV
	JMP	PXR1	;go push remainder
;
;	PSO - Preset shift operation.
;	Exit	 A = shift count
;		HL = operand to be shifted
;
PSO:	CALL	PLV2	;pop two operands
	MOV	A,D
	ORA	A
	JNZ	PSO1	;If shifting too far
;
	MOV	A,E
	CPI	17
	RC		;If shift count < 17
;
;	Shift count is too big.
;
PSO1:	CALL	ERX	;issue error "E"
	MVI	A,16
	RET
;
;	PSL - Process shift left.
;
PSL:	CALL	PSO	;HL=operand, A=shift count
PSL1:	ORA	A
	JZ	PXR1	;If done
;
;	Shift HL left.
;
	DAD	H
	DCR	A
	JMP	PSL1
;
;	PSR - Process shift right.
;
PSR:	CALL	PSO	;HL=operand, A=shift count
PSR1:	ORA	A
	JZ	PXR1	;If done
;
;	Shift HL right.
;
	PUSH	PSW
	XRA	A	;clear carry
	MOV A,H ! RAR ! MOV H,A
	MOV A,L ! RAR ! MOV L,A
	POP	PSW
	DCR	A
	JMP	PSR1
;
;	PAD - Process addition operation.
;
PAD:	CALL	PLV2	;pop two operands
	DAD	D
	JMP	PXR1	;go push sum
;
;	PSB - Process subtraction operation.
;
PSB:	CALL	PLV2	;pop two operands
	XCHG
	CALL	NHL	;negate HL
	DAD	D
	JMP	PXR1	;go push difference
;
;	NHL - Negate HL.
;
NHL:	XRA	A
	SUB L ! MOV L,A
	MVI	A,0
	SBB H ! MOV H,A
	RET
;
;	PNG - Process negation operation.
;
PNG:	CALL	PLV	;pop one operand
	CALL	NHL
	JMP	PXR1	;go push negation
;
;	PNT - Process NOT operation.
;
PNT:	CALL	PLV	;pop one operand
	INX	H
	CALL	NHL
	JMP	PXR1	;go push inversion
;
;	PAN - Process AND operation.
;
PAN:	CALL	PLV2	;pop two operands
	MOV A,D ! ANA H ! MOV H,A
	MOV A,E ! ANA L ! MOV L,A
	JMP	PXR1	;go push masked result
;
;	POR - Process OR operation.
;
POR:	CALL	PLV2	;pop two operands
	MOV A,D ! ORA H ! MOV H,A
	MOV A,E ! ORA L ! MOV L,A
	JMP	PXR1	;go push combined result
;
;	PXR - Process XOR operation.
;
PXR:	CALL	PLV2	;pop two operands
	MOV A,D ! XRA H ! MOV H,A
	MOV A,E ! XRA L ! MOV L,A
;
;	Push HL on to the operand stack.
;
PXR1:	CALL	PHV
	RET
;
;	PEX - Process end of expression.
;	Exit	 Z = true, if end of expression
;
PEX:	LDA	TOKEN
	CPI	SPECL
	RNZ		;If not end of expression
;
	LDA	ACCUM
	CPI cr  ! RZ	;If carriage return
	CPI ';' ! RZ	;If start of comment
	CPI ',' ! RZ	;If expression separator
	CPI '!' ! RET	;If statement separator
;
;	SOF - Scan operand field.
;
SOF:	XRA	A	;reset stacks
	STA	OSP
	STA	VSP
	DCR	A	;mark unary true
	STA	UNARY
	LXI	H,0	;reset expression value
	SHLD	EVALUE
;
SOF1:	CALL	PEX	;check end of expression
	JNZ	SOF5	;If not at expression end
;
;	We are at the end of the expression.
;	Empty the operator stack.
;
SOF2:	LXI	H,OSP
	MOV	A,M
	ORA	A
	JZ	SOF3	;If stack emptied
;
	DCR	M	;pop next operator
	MOV E,A ! MVI D,0
	DCX	D
	LXI	H,OPERV
	DAD	D
	MOV	A,M
	CALL	APO	;apply operation
	JMP	SOF2
;
;	The operator stack is empty.
;	We must have one variable on operand stack.
;
SOF3:	LDA	VSP
	CPI	2
	JNZ	SOF4	;If stack not correctly reduced
;
;	Return the value of the expression.
;
	LHLD	VSTACK
	SHLD	EVALUE
	RET
;
;	Evaluation failed; return value = 0.
;
SOF4:	CALL	ERX	;issue error "E"
	RET
;
;	Continue expression scan.
;
SOF5:	LDA	PLBFWA
	CPI	' '
	JNZ	SOF25	;If an error flag set, skip to end
;
;	Check string.
;
	LDA	TOKEN
	CPI	STRNG
	JNZ	SOF7	;If not string
;
;	Process string expression.
;
	LDA	ACCLEN
	ORA	A
	CZ	ERX	;If length=0, issue error "E"
	CPI	3
	CNC	ERX	;If length>2, issue error "E"
;
	MVI	D,0
	LXI	H,ACCUM
	MOV	E,M
	INX	H
	DCR	A
	JZ	SOF6	;If one byte
;
	MOV	D,M
SOF6:	XCHG
	JMP	SOF24	;go push operand
;
;	Check number.
;
SOF7:	CPI	NUMBR
	JNZ	SOF8	;If not number
;
;	Process number.
;
	LHLD	VALUE
	JMP	SOF24	;go push operand
;
;	Check identifier.
;
SOF8:	CALL	MTPGMV	;get A=type, B=value
	JNZ	SOF19	;If not mnemonic
;
	CPI	LOPER+1
	JNC	SOF18	;If not an operator
;
;	Process operator.
;	B = priority, A = operator
;
	CPI	LPAR
	MOV	C,A	;save operator
	LDA	UNARY
	JNZ	SOF9	;If not open paren
;
;	We have a left parenthesis; unary must still be true.
;
	ORA	A
	CZ	ERX	;If unary marked false, issue error "E"
;
	MVI	A,0FFH	;set unary true
	STA	UNARY
	MOV	A,C
	JMP	SOF14
;
;	It is not left paren; check unary.
;
SOF9:	ORA	A
	JNZ	SOF16	;If unary true
;
;	Unary is false, process binary operator.
;
SOF10:	PUSH	B	;save priority
	LDA	OSP
	ORA	A
	JZ	SOF11	;If operand stack empty
;
;	Compare current priority with stacked priority.
;
	MOV E,A ! MVI D,0
	DCX	D
	LXI	H,HIERV
	DAD	D
	MOV	A,M
	CMP	B
	JC	SOF11	;If current priority is higher
;
;	The waiting operation has higher priority.
;	Pop stacks and apply operation.
;
	LXI	H,OSP
	MOV	M,E	;osp=osp-1
	LXI	H,OPERV
	DAD	D
	MOV	A,M	;operator
	CALL	APO
	POP	B	;restore B=priority, C=operator
	JMP	SOF10
;
;	The operand stack is empty.
;
SOF11:	POP	B	;restore B=priority, C=operator
	MOV	A,C
	CPI	RPAR
	JNZ	SOF14	;If not closing parenthesis
;
;	We have a right paren, so
;	there should be a left paren.
;
	LXI	H,OSP
	MOV	A,M
	ORA	A
	JZ	SOF12	;If stack empty
;
;	The left parenthesis may be there.
;
	DCR	A	;pop operator stack
	MOV	M,A
	MOV E,A ! MVI D,0
	LXI	H,OPERV
	DAD	D
	MOV	A,M
	CPI	LPAR
	JZ	SOF13	;If parentheses balance
;
;	Parentheses are out of balance.
;
SOF12:	CALL	ERX	;issue error "E"
SOF13:	XRA	A
	JMP	SOF15
;
;	Process operator.
;
SOF14:	CALL	PHO	;push the operator
	MVI	A,0FFH	;mark unary true
SOF15:	STA	UNARY
	JMP	SOF25
;
;	Process unary +, -, or NOT.
;
SOF16:	MOV	A,C
	CPI	PLUS
	JZ	SOF25	;If unary +
;
	CPI	MINUS
	JNZ	SOF17	;If not unary -
;
	INR	A
	MOV	C,A
	JMP	SOF10
;
;	Check unary NOT.
;
SOF17:	CPI	NOTF
	CNZ	ERX	;If not unary NOT, issue error "E"
	JMP	SOF10
;
;	Process non-operator.
;
SOF18:	CPI	PT
	CZ	ERX	;If pseudo-op, issue error "E"
	MOV	L,B
	MVI	H,0
	JMP	SOF24
;
;	Process "other."
;
SOF19:	LDA	TOKEN
	CPI	SPECL
	JNZ	SOF21	;If not "other"
;
;	Process special character.
;
	LDA	ACCUM
	CPI	'$'
	JZ	SOF20	;If use current location counter
;
	CALL	ERX	;issue error "E"
	LXI	H,0
	JMP	SOF24
;
;	Set expression value to current location counter.
;
SOF20:	LHLD	LOCCN
	JMP	SOF24
;
;	Check the symbol table.
;
SOF21:	CALL	STMSFS	;search for symbol
	CALL	STMCSF
	JNZ	SOF22	;If symbol found
;
;	Symbol not found.
;
	MVI	A,'P'	;set "phase" error
	CALL	IOMPER
	CALL	STMEST	;enter symbol into table
	JMP	SOF23
;
;	Symbol was found.
;
SOF22:	CALL	STMGTY	;get symbol type
	ANI	07H
	MVI	A,'U'
	CZ	IOMPER	;If type=undefined
;
SOF23:	CALL	STMGSV	;get the symbol value
;
;	HL = expression value.
;	Push value on the operand stack.
;	If operand encountered while unary=false,
;	then issue error flag.
;
SOF24:	LDA	UNARY
	ORA	A
	CZ	ERX	;If unary false, issue error "E"
;
	XRA	A	;mark unary false
	STA	UNARY
	CALL	PHV	;push operand
;
;	Scan next token.
;
SOF25:	CALL	SCNSNT
	JMP	SOF1
;
;	ERX - Issue expression error.
;
ERX:	PUSH	H
	MVI	A,'E'
	CALL	IOMPER
	POP	H
	RET
;
ENDEVA	EQU	($ AND 0FF00H) + 100H
